package com.adobe.pdfservices.operation.internal.cpf.dto.request.platform;

import com.adobe.pdfservices.operation.pdfops.options.extractpdf.*;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
public class ExtractPDFParams implements PlatformParams {

    @JsonProperty("elementsToExtract")
    private List<ExtractElementType> elementsToExtract;

    @JsonProperty("renditionsToExtract")
    private List<ExtractRenditionsElementType> renditionsToExtract;

    @JsonProperty("tableOutputFormat")
    private TableStructureType tableOutFormat;

    @JsonProperty("getCharBounds")
    private Boolean extractCharInfo;

    @JsonProperty("includeStyling")
    private Boolean getStylingInfo;

    public ExtractPDFParams(ExtractPDFOptions extractPDFOptions) {
        this.elementsToExtract = extractPDFOptions.getElementsToExtract();
        this.renditionsToExtract = extractPDFOptions.getElementsToExtractRenditions();
        this.tableOutFormat = extractPDFOptions.getTableStructureType();
        this.extractCharInfo = extractPDFOptions.getAddCharInfo();
        this.getStylingInfo = extractPDFOptions.getStylingInfo();
    }

    public static ExtractPDFParams createFrom(ExtractPDFOptions extractPDFOptions) {
        ExtractPDFParams extractPDFParams = null;

        if (extractPDFOptions != null) {
            extractPDFParams = new ExtractPDFParams((ExtractPDFOptions) extractPDFOptions);
        } else {
            extractPDFParams = new ExtractPDFParams(ExtractPDFOptions.extractPdfOptionsBuilder().addElementToExtract(ExtractElementType.TEXT).build());
        }

        return extractPDFParams;
    }
}
