/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation.internal.cpf.dto.request.platform;

import java.util.ArrayList;
import java.util.List;

import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.pagemanipulation.DeletePageAction;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.pagemanipulation.PageActionCommand;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.pagemanipulation.PageActionParams;
import com.adobe.pdfservices.operation.pdfops.options.PageRanges;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class DeletePagesParams implements PlatformParams {

    @JsonProperty("pageActions")
    private List<PageActionParams> pageActionParams;

    public DeletePagesParams(List<PageActionParams> pageActionParams) {
        this.pageActionParams = pageActionParams;
    }

    public static DeletePagesParams createFrom(PageRanges pageRanges) {

        List<PageActionParams> pageActionParams = new ArrayList<>();

        DeletePageAction deletePageAction = new DeletePageAction(pageRanges.getRanges());
        pageActionParams.add(new PageActionParams(PageActionCommand.createFrom(deletePageAction)));

        return new DeletePagesParams(pageActionParams);
    }
}
