/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.pagewidgets.granite;

import com.adobe.cq.testing.selenium.pageobject.granite.ViewType;
import com.adobe.cq.testing.selenium.pagewidgets.Helpers;
import com.adobe.cq.testing.selenium.pagewidgets.common.AEMBaseComponent;
import com.adobe.cq.testing.selenium.pagewidgets.coral.CoralReady;
import com.adobe.cq.testing.selenium.pagewidgets.coral.Dialog;
import com.adobe.cq.testing.selenium.pagewidgets.cq.AutoCompleteField;
import com.adobe.cq.testing.selenium.pagewidgets.granite.Collection;
import com.adobe.cq.testing.selenium.pagewidgets.granite.CollectionSwitcher;
import com.adobe.cq.testing.selenium.pagewidgets.granite.Masonry;
import com.adobe.cq.testing.selenium.pagewidgets.granite.Table;
import com.adobe.cq.testing.selenium.pagewidgets.granite.columnview.ColumnView;
import com.adobe.cq.testing.selenium.pagewidgets.granite.columnview.ColumnViewItem;
import com.adobe.cq.testing.selenium.utils.ElementUtils;
import com.codeborne.selenide.Selenide;
import java.util.EnumMap;
import org.openqa.selenium.Keys;

public final class Picker
extends Dialog {
    private Collection collection;
    private EnumMap<ViewType, Collection> viewIconToWrapperClassMap = new EnumMap(ViewType.class);
    private static final AutoCompleteField<AEMBaseComponent> FULL_TEXT_SEARCH = new AutoCompleteField("fulltext");
    private ViewType currentViewType;
    private boolean isSingleCollection;
    private static final long NETWORK_IDLE_INTERVAL = 250L;
    private static final String BASE_COLLECTION_SELECTOR = ".foundation-collection";
    private static final String PICKER_CONTENT_SELECTOR = ".foundation-layout-panel-content:not([hidden]) ";

    public Picker() {
        this("coral-dialog.foundation-picker-collection.is-open");
    }

    public Picker(String selector) {
        this(selector, null);
    }

    public Picker(String selector, ViewType viewType) {
        super(selector);
        this.initViews();
        this.setViewType(viewType);
    }

    private void initViews() {
        this.viewIconToWrapperClassMap.put(ViewType.CARD, new Masonry(".foundation-layout-panel-content:not([hidden]) .foundation-collection"));
        this.viewIconToWrapperClassMap.put(ViewType.LIST, new Table(".foundation-layout-panel-content:not([hidden]) .foundation-collection"));
        this.viewIconToWrapperClassMap.put(ViewType.COLUMN, new ColumnView(".foundation-layout-panel-content:not([hidden]) .foundation-collection"));
    }

    public ColumnViewItem getItem(String itemId) {
        if (this.currentViewType == ViewType.COLUMN) {
            return ((ColumnView)this.collection).getItem(itemId);
        }
        return null;
    }

    public Picker toggleItem(String itemId) {
        this.collection.toggleSelectionItem(itemId);
        return this;
    }

    public Picker activateItem(String itemId) {
        this.collection.activate(itemId);
        return this;
    }

    public Picker close() {
        String closeButtonCss = this.getCssSelector() + " coral-dialog-content button[is='coral-button'][coral-close][variant='quiet']";
        ElementUtils.clickableClick(Selenide.$((String)closeButtonCss));
        this.waitVanish();
        return this;
    }

    public Picker submit() {
        String submitButtonCss = this.getCssSelector() + " coral-dialog-content button.granite-pickerdialog-submit[is='coral-button']";
        ElementUtils.clickableClick(Selenide.$((String)submitButtonCss));
        this.waitVanish();
        return this;
    }

    private void switchToView(ViewType viewType, Collection viewCollection) {
        String collectionSelector = viewCollection.getCssSelector();
        boolean viewChanged = new CollectionSwitcher().switchToView(viewType);
        if (viewChanged) {
            Helpers.waitNetworkIdled(250L);
            CoralReady.waitCoralReady(collectionSelector);
        }
        this.currentViewType = viewType;
        this.collection = viewCollection;
    }

    public Picker switchToView(ViewType viewType) {
        Collection viewCollection = this.viewIconToWrapperClassMap.get((Object)viewType);
        if (viewCollection == null || this.isSingleCollection) {
            throw new UnsupportedOperationException("Unsupported view");
        }
        this.switchToView(viewType, viewCollection);
        return this;
    }

    public Picker setViewType(ViewType viewType) {
        this.isSingleCollection = true;
        this.currentViewType = viewType;
        this.collection = this.viewIconToWrapperClassMap.get((Object)viewType);
        return this;
    }

    public Picker searchFulltext(String keywords) {
        FULL_TEXT_SEARCH.sendKeys(new CharSequence[]{keywords, Keys.ENTER});
        return this;
    }

    public Collection collection() {
        return this.collection;
    }
}

