/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.pagewidgets.granite;

import com.adobe.cq.testing.selenium.Constants;
import com.adobe.cq.testing.selenium.pageobject.granite.ViewType;
import com.adobe.cq.testing.selenium.pagewidgets.common.AEMBaseComponent;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.SelenideElement;

public class CollectionSwitcher
extends AEMBaseComponent {
    private static final String SWITCHER_ICON_PLACEHOLDER = "%icon%";
    private final String viewButtonSelector;
    private final String currentViewButtonSelector = this.getCssSelector() + " button[is='coral-button'] coral-icon[icon='%icon%']";
    private final String toggleButtonSelector;
    private final String popoverMenuSelector = this.getCssSelector() + "-menu";

    public CollectionSwitcher() {
        super("#granite-collection-switcher-toggle");
        this.viewButtonSelector = this.popoverMenuSelector + " coral-selectlist-item coral-icon[icon='%icon%']";
        this.toggleButtonSelector = "#granite-collection-switcher-toggle-button";
    }

    private String createSwitchButtonSelector(String viewIcon) {
        return this.viewButtonSelector.replace(SWITCHER_ICON_PLACEHOLDER, viewIcon);
    }

    private String createCurrentViewButtonSelector(String viewIcon) {
        return this.currentViewButtonSelector.replace(SWITCHER_ICON_PLACEHOLDER, viewIcon);
    }

    public boolean switchToView(ViewType viewType) {
        this.element().should(Constants.EXISTS_ENABLED_VISIBLE);
        String viewIcon = viewType.iconName();
        SelenideElement currentViewButton = Selenide.$((String)this.createCurrentViewButtonSelector(viewIcon));
        if (currentViewButton.isDisplayed()) {
            return false;
        }
        this.element().click();
        if (Selenide.$((String)this.toggleButtonSelector).has(Condition.attribute((String)"aria-haspopup", (String)"true"))) {
            Selenide.$((String)this.popoverMenuSelector).should(new Condition[]{Condition.cssClass((String)"is-open")}).shouldBe(Constants.EXISTS_ENABLED_VISIBLE);
            Selenide.$((String)this.createSwitchButtonSelector(viewIcon)).should(Constants.EXISTS_ENABLED_VISIBLE).click();
            Selenide.$((String)this.popoverMenuSelector).shouldNotBe(new Condition[]{Condition.visible});
        }
        return true;
    }
}

