/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.pagewidgets.cq;

import com.adobe.cq.testing.selenium.Constants;
import com.adobe.cq.testing.selenium.pageobject.cq.sites.CreateWorkflowWizard;
import com.adobe.cq.testing.selenium.pagewidgets.common.AEMBaseComponent;
import com.adobe.cq.testing.selenium.pagewidgets.coral.CoralPopOver;
import com.adobe.cq.testing.selenium.pagewidgets.coral.CoralSelectList;
import com.adobe.cq.testing.selenium.pagewidgets.coral.CoralStepList;
import com.adobe.cq.testing.selenium.pagewidgets.cq.FormField;
import com.adobe.cq.testing.selenium.pagewidgets.cq.TimelineWorkflowEvent;
import com.adobe.cq.testing.selenium.utils.ElementUtils;
import com.adobe.cq.testing.selenium.utils.ExpectNav;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.SelenideElement;
import org.openqa.selenium.Keys;

public class TimelinePanel
extends AEMBaseComponent {
    public static final SelenideElement COMMENT_FIELD = new FormField("cq-common-admin-timeline-toolbar-actions-comment").getFullyDecoratedElement("input", new String[0]);
    public static final SelenideElement VERSION_LABEL = new FormField("label").getFullyDecoratedElement("input", new String[0]);
    public static final SelenideElement VERSION_COMMENT = new FormField("comment").getFullyDecoratedElement("textarea", new String[0]);
    private static final SelenideElement MORE_ACTIONS_BUTTON = Selenide.$((String)"[data-rel=\"cq-common-admin-timeline-toolbar-actions-main\"] coral-icon");
    private static final SelenideElement SAVE_AS_VERSION_BUTTON = Selenide.$((String)"[data-rel=\"cq-common-admin-timeline-toolbar-actions-version\"]");
    private static final SelenideElement START_WORKFLOW_BUTTON = Selenide.$((String)"button.cq-common-admin-timeline-toolbar-actions-workflow");
    private static final SelenideElement FORM_VERSION = Selenide.$((String)"form.cq-common-admin-timeline-toolbar-actions-version-form");
    private static final SelenideElement VERSION_CREATE_BUTTON = Selenide.$((String)".cq-common-admin-timeline-toolbar-actions-version-ok");
    private static final SelenideElement TIMELINE_MORE_BUTTON = Selenide.$((String)"button.cq-common-admin-timeline-more-button");
    private static final String TIMELINE_EVENT_SELECTOR = ".cq-common-admin-timeline-event";
    private static final String TIMELINE_TITLES_SELECTOR = ".cq-common-admin-timeline-event-title";
    private static final String TIMELINE_BALLOONS_SELECTOR = ".cq-common-admin-timeline-event-balloon";
    private SelenideElement filter = this.element().$("button[variant=\"_custom\"]");

    public TimelinePanel() {
        super("coral-panel[data-shell-collectionpage-rail-panel=\"timeline\"]");
    }

    public boolean isOpened() {
        return this.element().has(Condition.cssClass((String)"is-selected")) && this.element().isDisplayed();
    }

    public void addComment(String comment) {
        COMMENT_FIELD.shouldBe(Constants.EXISTS_ENABLED_VISIBLE).sendKeys(new CharSequence[]{comment, Keys.ENTER});
    }

    public void saveVersion(String label, String comment) {
        ElementUtils.clickableClick(MORE_ACTIONS_BUTTON);
        ElementUtils.clickableClick(SAVE_AS_VERSION_BUTTON);
        FORM_VERSION.shouldBe(new Condition[]{Condition.visible});
        VERSION_LABEL.shouldBe(new Condition[]{Condition.visible}).sendKeys(new CharSequence[]{label});
        VERSION_COMMENT.shouldBe(new Condition[]{Condition.visible}).sendKeys(new CharSequence[]{comment});
        ElementUtils.clickableClick(VERSION_CREATE_BUTTON);
    }

    public ElementsCollection getTimelineEvents() {
        return this.element().$$(TIMELINE_EVENT_SELECTOR);
    }

    public ElementsCollection getExpandableTimelineEvents() {
        return this.element().$$(TIMELINE_EVENT_SELECTOR).filter(Condition.cssClass((String)"is-expandable"));
    }

    public TimelineWorkflowEvent getActiveExpandableTimelineEvents() {
        return new TimelineWorkflowEvent();
    }

    public TimelineWorkflowEvent selectExpandableEventByTitle(String title) {
        SelenideElement matchingEvent = this.getTimelineTitles().filter(Condition.text((String)title)).first();
        TimelineWorkflowEvent activeEvent = null;
        if (matchingEvent != null) {
            SelenideElement expandableEvent = matchingEvent.closest("section");
            if (!expandableEvent.has(Condition.cssClass((String)"is-active"))) {
                ElementUtils.clickableClick(expandableEvent);
            }
            activeEvent = this.getActiveExpandableTimelineEvents();
        }
        return activeEvent;
    }

    public ElementsCollection getTimelineBalloons() {
        return this.element().$$(TIMELINE_BALLOONS_SELECTOR);
    }

    public ElementsCollection getTimelineTitles() {
        return this.element().$$(TIMELINE_TITLES_SELECTOR);
    }

    public void more() {
        ElementUtils.clickableClick(TIMELINE_MORE_BUTTON);
    }

    public CoralSelectList filter() {
        ElementUtils.clickableClick(this.filter);
        CoralPopOver popOver = CoralPopOver.firstOpened();
        popOver.waitVisible();
        return new CoralSelectList(popOver.element());
    }

    public boolean hasMore() {
        return TIMELINE_MORE_BUTTON.isDisplayed();
    }

    public void startWorkflow(String modelId, String title) {
        ElementUtils.clickableClick(MORE_ACTIONS_BUTTON);
        ExpectNav.on(() -> ElementUtils.clickableClick(START_WORKFLOW_BUTTON));
        CreateWorkflowWizard createWfWiz = new CreateWorkflowWizard();
        Selenide.Wait().until(w -> createWfWiz.isOpened());
        createWfWiz.selectModel(modelId);
        createWfWiz.title().sendKeys(new CharSequence[]{title});
        createWfWiz.next();
        CoralStepList stepList = createWfWiz.stepList();
        Selenide.Wait().until(w -> "Scope".equals(stepList.getCurrentStepLabel()));
        ExpectNav.on(createWfWiz::next);
    }
}

