/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.pagewidgets.cq;

import com.adobe.cq.testing.selenium.pagewidgets.coral.Dialog;
import com.adobe.cq.testing.selenium.pagewidgets.cq.RichTextToolbar;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.SelenideElement;

public class RichTextDialog
extends Dialog {
    private static final String CSS_SELECTOR = "coral-dialog";
    private static final String EDITABLE = ".cq-RichText-editable";
    private static final String SOURCE_CODE_EDITOR = ".rte-sourceEditor";

    public RichTextDialog() {
        super(CSS_SELECTOR);
    }

    public RichTextDialog(SelenideElement element) {
        super(element);
    }

    public SelenideElement getEditable() {
        return this.element().find(EDITABLE);
    }

    public String getText() {
        return this.getEditable().shouldBe(new Condition[]{Condition.visible}).getText();
    }

    public String getPlainText() {
        return this.getEditable().shouldBe(new Condition[]{Condition.visible}).getValue();
    }

    public String setText(String text) {
        SelenideElement editableElement = this.getEditable().shouldBe(new Condition[]{Condition.visible});
        editableElement.toWebElement().clear();
        editableElement.sendKeys(new CharSequence[]{text});
        return this.getText();
    }

    public RichTextToolbar getToolbar() {
        RichTextToolbar toolbar = new RichTextToolbar();
        toolbar.element().shouldBe(new Condition[]{Condition.visible});
        this.getEditable().shouldBe(new Condition[]{Condition.visible});
        return toolbar;
    }

    public RichTextDialog clickCancel() {
        return (RichTextDialog)super.clickDefault();
    }

    public RichTextDialog clickDone() {
        return (RichTextDialog)super.clickPrimary();
    }
}

