/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.pagewidgets.cq;

import com.adobe.cq.testing.selenium.pagewidgets.Helpers;
import com.adobe.cq.testing.selenium.pagewidgets.common.AEMBaseComponent;
import com.adobe.cq.testing.selenium.pagewidgets.common.ActionComponent;
import com.adobe.cq.testing.selenium.pagewidgets.coral.CoralReady;
import com.adobe.cq.testing.selenium.pagewidgets.coral.Dialog;
import com.adobe.cq.testing.selenium.pagewidgets.cq.PolicyDialog;
import com.adobe.cq.testing.selenium.utils.ElementUtils;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.SelenideElement;

public final class PageInfo
extends AEMBaseComponent {
    private static final String PAGEINFO_IDENTIFIER = "#pageinfo-data";
    private static final String BUTTON_SELECTOR = "#pageinfo-trigger";
    private SelenideElement button = Selenide.$((String)"#pageinfo-trigger");
    private static final String OPEN_PROPERTIES = "Open Properties";
    private static final String ROLLOUT_PAGE = "Rollout Page";
    private static final String START_WORKFLOW = "Start Workflow";
    private static final String LOCK_PAGE = "Lock Page";
    private static final String UNLOCK_PAGE = "Unlock Page";
    private static final String PUBLISH_PAGE = "Publish Page";
    private static final String REQUEST_PUBLICATION = "Request Publication";
    private static final String UNPUBLISH_PAGE = "Unpublish Page";
    private static final String REQUEST_UNPUBLICATION = "Request Unpublication";
    private static final String PROMOTE_LAUNCH = "Promote Launch";
    private static final String OPEN_ANALYTICS = "Open Analytics &amp; Recommendations";
    private static final String EDIT_TEMPLATE = "Edit Template";
    private static final String VIEW_AS_PUBLISHED = "View as Published";
    private static final String VIEW_IN_ADMIN = "View in Admin";
    private static final String OPEN_IN_CLASSIC = "Open in Classic UI";
    private static final String HELP = "Help";
    private static final String INITIAL_PAGE_PROPERTIES = "Initial Page Properties";
    private static final String PAGE_POLICY = "Page Policy";
    private static final String PUBLISH_TEMPLATE = "Publish Template";
    private SelenideElement buttonPageProps = Selenide.$((String)"button[title='Open Properties']");
    private SelenideElement buttonRolloutPage = Selenide.$((String)"button[title='Rollout Page']");
    private SelenideElement buttonStartWorkflow = Selenide.$((String)"button[title='Start Workflow']");
    private SelenideElement buttonLockPage = Selenide.$((String)"button[title='Lock Page']");
    private SelenideElement buttonUnlockPage = Selenide.$((String)"button[title='Unlock Page']");
    private SelenideElement buttonPublishPage = Selenide.$((String)"button[title='Publish Page']");
    private SelenideElement buttonRequestPublication = Selenide.$((String)"button[title='Request Publication']");
    private SelenideElement buttonUnpublishPage = Selenide.$((String)"button[title='Unpublish Page']");
    private SelenideElement buttonRequestUnpublication = Selenide.$((String)"button[title='Request Unpublication']");
    private SelenideElement buttonPromoteLaunch = Selenide.$((String)"button[title='Promote Launch']");
    private SelenideElement buttonOpenAnalytics = Selenide.$((String)"button[title='Open Analytics &amp; Recommendations']");
    private SelenideElement buttonEditTemplate = Selenide.$((String)"button[title='Edit Template']");
    private SelenideElement buttonViewAsPublished = Selenide.$((String)"button[title='View as Published']");
    private SelenideElement buttonViewInAdmin = Selenide.$((String)"button[title='View in Admin']");
    private SelenideElement buttonOpenInClassic = Selenide.$((String)"button[title='Open in Classic UI']");
    private SelenideElement buttonHelp = Selenide.$((String)"button[title='Help']");
    private SelenideElement buttonInitialPageProps = Selenide.$((String)"button[title='Initial Page Properties']");
    private SelenideElement buttonPagePolicy = Selenide.$((String)"button[title='Page Policy']");
    private ActionComponent<PolicyDialog> pagePolicyButton = new ActionComponent<Object>("button[title='Page Policy']", () -> new PolicyDialog(), false);
    private SelenideElement buttonPublishTemplate = Selenide.$((String)"button[title='Publish Template']");
    private Dialog unlockPageDialog = new Dialog("coral-dialog");
    private Dialog unpublishPageDialog = new Dialog("coral-dialog");

    public PageInfo() {
        super(PAGEINFO_IDENTIFIER);
    }

    public boolean isOpen() {
        return this.element().isDisplayed();
    }

    public boolean isClosed() {
        return !this.isOpen();
    }

    public PageInfo open() {
        if (this.isClosed()) {
            this.togglePageInfo();
            this.element().should(new Condition[]{Condition.exist}).shouldBe(new Condition[]{Condition.visible});
        }
        return this;
    }

    public PageInfo close() {
        if (this.isOpen()) {
            this.togglePageInfo();
            this.element().should(new Condition[]{Condition.exist}).shouldNotBe(new Condition[]{Condition.visible});
        }
        return this;
    }

    public SelenideElement getOpenPagePropertiesButton() {
        return this.buttonPageProps;
    }

    public SelenideElement getRolloutPageButton() {
        return this.buttonRolloutPage;
    }

    public SelenideElement getStartWorkflowButton() {
        return this.buttonStartWorkflow;
    }

    public SelenideElement getLockPageButton() {
        return this.buttonLockPage;
    }

    public SelenideElement getUnLockPageButton() {
        return this.buttonUnlockPage;
    }

    public SelenideElement getPublishPageButton() {
        return this.buttonPublishPage;
    }

    public SelenideElement getRequestPublicationButton() {
        return this.buttonRequestPublication;
    }

    public SelenideElement getUnpublishPageButton() {
        return this.buttonUnpublishPage;
    }

    public SelenideElement getRequestUnpublicationButton() {
        return this.buttonRequestUnpublication;
    }

    public SelenideElement getPromoteLaunchButton() {
        return this.buttonPromoteLaunch;
    }

    public SelenideElement getOpenAnalyticsButton() {
        return this.buttonOpenAnalytics;
    }

    public SelenideElement getEditTemplateButton() {
        return this.buttonEditTemplate;
    }

    public SelenideElement getViewAsPublishedButton() {
        return this.buttonViewAsPublished;
    }

    public SelenideElement getViewInAdminButton() {
        return this.buttonViewInAdmin;
    }

    public SelenideElement getOpenInClassicButton() {
        return this.buttonOpenInClassic;
    }

    public SelenideElement getHelpButton() {
        return this.buttonHelp;
    }

    public SelenideElement getInitialPagePropertiesButton() {
        return this.buttonInitialPageProps;
    }

    public SelenideElement getPagePolicyButton() {
        return this.buttonPagePolicy;
    }

    public SelenideElement getPublishTemplateButton() {
        return this.buttonPublishTemplate;
    }

    public PolicyDialog clickPagePolicy() {
        return Helpers.clickDialogAction(this.pagePolicyButton);
    }

    public Dialog clickUnlockPageButton() {
        return Helpers.clickDialogAction(this.getUnLockPageButton(), this.unlockPageDialog);
    }

    public Dialog clickUnpublishPageButton() {
        return Helpers.clickDialogAction(this.getUnpublishPageButton(), this.unpublishPageDialog);
    }

    private void togglePageInfo() {
        CoralReady.waitCoralReady(BUTTON_SELECTOR);
        ElementUtils.clickableClick(this.button, 2000L);
    }
}

