/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.pagewidgets.cq;

import com.adobe.cq.testing.selenium.pagewidgets.common.AEMBaseComponent;
import com.adobe.cq.testing.selenium.pagewidgets.cq.EditableToolbar;
import com.adobe.cq.testing.selenium.pagewidgets.cq.RichTextToolbar;
import com.adobe.cq.testing.selenium.utils.ElementUtils;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.SelenideElement;
import org.openqa.selenium.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InlineEditor
extends AEMBaseComponent {
    private static final Logger LOG = LoggerFactory.getLogger(InlineEditor.class);
    private static final String INLINEEDITOR_IDENTIFIER = "#InlineEditingUI";
    private static final String CONTENT_FRAME = "ContentFrame";
    private static final String TEXT_CONTENT_SELECTOR = ".text.cq-Editable-dom";
    private static final String TEXT_CONTENT_EDITABLE_SELECTOR = ".text.cq-Editable-dom[contenteditable]";
    private static final String SAVE_BUTTON = "[data-action='control#save']";
    private static final String CLOSE_BUTTON = "[data-action='control#close']";
    private SelenideElement saveButton = Selenide.$((String)"[data-action='control#save']");
    private SelenideElement closeButton = Selenide.$((String)"[data-action='control#close']");
    private EditableToolbar editableToolbar;
    private RichTextToolbar richTextToolbar;

    public InlineEditor(EditableToolbar editableToolbar) {
        super(INLINEEDITOR_IDENTIFIER);
        this.editableToolbar = editableToolbar;
        this.richTextToolbar = new RichTextToolbar();
    }

    public EditableToolbar save() {
        return this.clickAction(this.saveButton);
    }

    public EditableToolbar close() {
        return this.clickAction(this.closeButton);
    }

    private EditableToolbar clickAction(SelenideElement button) {
        ElementUtils.clickableClick(button);
        this.element().shouldNotBe(new Condition[]{Condition.visible});
        this.editableToolbar.element().shouldBe(new Condition[]{Condition.visible});
        return this.editableToolbar;
    }

    public RichTextToolbar getRichTextToolbar() {
        return this.richTextToolbar;
    }

    public String getTextContent() {
        return this.setOrGetTextContent(null);
    }

    public String setTextContent(String textContent) {
        return this.setOrGetTextContent(textContent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String setOrGetTextContent(String textContent) {
        Selenide.switchTo().frame(CONTENT_FRAME);
        String newTextContent = "";
        try {
            newTextContent = textContent == null ? Selenide.$((String)TEXT_CONTENT_EDITABLE_SELECTOR).should(new Condition[]{Condition.exist}).getText() : Selenide.$((String)TEXT_CONTENT_EDITABLE_SELECTOR).should(new Condition[]{Condition.exist}).setValue(textContent).getText();
        }
        catch (NoSuchElementException nse) {
            LOG.warn("No inline editing element found - open inline editor first by click to editable toolbar edit button: " + nse.getLocalizedMessage());
        }
        finally {
            Selenide.switchTo().defaultContent();
        }
        return newTextContent;
    }
}

