/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.pagewidgets.cq;

import com.adobe.cq.testing.selenium.Constants;
import com.adobe.cq.testing.selenium.pagewidgets.coral.Dialog;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.SelenideElement;

public final class IncludeChildrenDialog
extends Dialog {
    private static final String CSS_SELECTOR = "coral-dialog.cq-common-include-children-dialog";
    private static final String INCLUDE_CHILDREN_SELECTOR = "coral-checkbox[name=\"includeChildren\"]";
    private static final String IMMEDIATE_CHILDREN_SELECTOR = "coral-checkbox[name=\"onlydirect\"]";
    private static final String MODIFIED_CHILDREN_SELECTOR = "coral-checkbox[name=\"onlymodified\"]";
    private static final String PUBLISHED_CHILDREN_SELECTOR = "coral-checkbox[name=\"reactivate\"]";
    private final SelenideElement immediateChildrenField;
    private final SelenideElement includeChildrenField = this.element().$("coral-checkbox[name=\"includeChildren\"]");
    private final SelenideElement modifiedChildrenField;
    private final SelenideElement publishedChildrenField;

    public IncludeChildrenDialog() {
        super(CSS_SELECTOR);
        this.immediateChildrenField = this.element().$(IMMEDIATE_CHILDREN_SELECTOR);
        this.modifiedChildrenField = this.element().$(MODIFIED_CHILDREN_SELECTOR);
        this.publishedChildrenField = this.element().$(PUBLISHED_CHILDREN_SELECTOR);
    }

    public boolean getIncludeChildrenField() {
        return this.getIsCheckedState(this.includeChildrenField);
    }

    public void checkIncludeChildrenField() {
        this.toggleIfNot(this.includeChildrenField, true);
    }

    public void uncheckIncludeChildrenField() {
        this.toggleIfNot(this.includeChildrenField, false);
    }

    public boolean getImmediateChildrenField() {
        return this.getIsCheckedState(this.immediateChildrenField);
    }

    public void checkOnlyDirectChildrenField() {
        this.toggleIfNot(this.immediateChildrenField, true);
    }

    public void uncheckOnlyDirectChildrenField() {
        this.toggleIfNot(this.immediateChildrenField, false);
    }

    public boolean getModifiedChildrenField() {
        return this.getIsCheckedState(this.modifiedChildrenField);
    }

    public void checkModifiedChildrenField() {
        this.toggleIfNot(this.modifiedChildrenField, true);
    }

    public void uncheckModifiedChildrenField() {
        this.toggleIfNot(this.modifiedChildrenField, false);
    }

    public boolean getPublishedChildrenField() {
        return this.getIsCheckedState(this.publishedChildrenField);
    }

    public void checkPublishedChildrenField() {
        this.toggleIfNot(this.publishedChildrenField, true);
    }

    public NoChildrenWarningDialog noChildrenWarningDialog() {
        return new NoChildrenWarningDialog();
    }

    public void uncheckPublishedChildrenField() {
        this.toggleIfNot(this.publishedChildrenField, false);
    }

    private void toggleIfNot(SelenideElement element, boolean newState) {
        element.should(Constants.EXISTS_ENABLED_VISIBLE);
        if (this.getIsCheckedState(element) != newState) {
            element.click();
        }
    }

    private boolean getIsCheckedState(SelenideElement element) {
        return element.getAttribute("checked") != null;
    }

    public static final class NoChildrenWarningDialog
    extends Dialog {
        private static final String CSS_SELECTOR = "coral-dialog[role=\"alertdialog\"]";
        private static final String WARNING_TEXT = "There are no filtered child resources for the selected item.";
        private static final String CLOSE_BUTTON = "button[handle=\"closeButton\"]";
        SelenideElement closeButton = this.element().$("button[handle=\"closeButton\"]");

        public NoChildrenWarningDialog() {
            super(CSS_SELECTOR);
        }

        public void isObserved() {
            this.waitVisible();
            this.element().shouldHave(new Condition[]{Condition.matchText((String)WARNING_TEXT)});
            this.closeButton.click();
            this.waitVanish();
        }
    }
}

