/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.pagewidgets.coral;

import com.adobe.cq.testing.selenium.pagewidgets.common.AEMBaseComponent;
import com.adobe.cq.testing.selenium.pagewidgets.coral.CoralPopOver;
import com.codeborne.selenide.CollectionCondition;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.SelenideElement;
import org.junit.Assert;
import org.openqa.selenium.NoSuchElementException;

public class CoralQuickActions
extends AEMBaseComponent {
    private ElementsCollection openedQuickActions = this.element().$$("coral-icon");

    public CoralQuickActions() {
        super("coral-quickactions.is-open");
    }

    public SelenideElement getQuickAction(String action) {
        ElementsCollection availableQuickActions = this.getOpenedQuickActions();
        availableQuickActions.shouldHave(new CollectionCondition[]{CollectionCondition.sizeGreaterThan((int)0)});
        ElementsCollection filteredActions = availableQuickActions.filter(Condition.attribute((String)"icon", (String)action)).filter(Condition.visible);
        Assert.assertTrue((filteredActions.size() <= 1 ? 1 : 0) != 0);
        if (filteredActions.size() == 1) {
            return filteredActions.get(0);
        }
        SelenideElement moreButton = this.element().$("button[icon=\"more\"]");
        if (moreButton.isDisplayed()) {
            moreButton.hover();
            moreButton.click();
            CoralPopOver popover = new CoralPopOver("._coral-QuickActions-moreOverlay");
            filteredActions = popover.element().$$("coral-icon").filter(Condition.attribute((String)"icon", (String)action)).filter(Condition.visible);
            filteredActions.shouldHave(new CollectionCondition[]{CollectionCondition.size((int)1)});
            return filteredActions.get(0);
        }
        throw new NoSuchElementException("Couldn't find " + action + " icon");
    }

    public ElementsCollection getOpenedQuickActions() {
        return this.openedQuickActions;
    }
}

