/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.pageobject.granite;

import com.adobe.cq.testing.selenium.pageobject.granite.BasePage;
import com.adobe.cq.testing.selenium.pageobject.granite.StartPage;
import com.adobe.cq.testing.selenium.pagewidgets.Helpers;
import com.adobe.cq.testing.selenium.pagewidgets.common.BaseComponent;
import com.adobe.cq.testing.selenium.pagewidgets.cq.FormField;
import com.adobe.cq.testing.selenium.utils.ElementUtils;
import com.adobe.cq.testing.selenium.utils.ExpectNav;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebDriverRunner;
import java.net.URI;
import org.openqa.selenium.Keys;

public final class LoginPage
extends BasePage {
    private static final String LOGIN_PAGE_PATH = "/libs/granite/core/content/login.html";
    private static final SelenideElement ACCORDION_ON_CLOUD = Selenide.$((String)"#coral-collection-id-0");
    public static final String LOGIN_TOKEN = "login-token";
    public static final String IMS_USER = System.getenv("IMS_USER");
    public static final String IMS_PASSWORD = System.getenv("IMS_PASSWORD");
    public static final SelenideElement IMS_PASSWORD_FIELD = new FormField("password").getFullyDecoratedElement("input", new String[0]);
    public static final SelenideElement IMS_USERNAME_FIELD = new FormField("username").getFullyDecoratedElement("input", new String[0]);
    public static final BaseComponent IMS_LOGIN_BUTTON = new BaseComponent("#submit-button-ims");

    public LoginPage(URI baseURL) {
        super(baseURL, LOGIN_PAGE_PATH);
    }

    public LoginPage() {
        super(LOGIN_PAGE_PATH);
    }

    public static boolean isLoggedIn() {
        return WebDriverRunner.getWebDriver().manage().getCookieNamed(LOGIN_TOKEN) != null;
    }

    public boolean isCloudLogin() {
        return ACCORDION_ON_CLOUD.exists();
    }

    public SelenideElement usernameField() {
        return Selenide.$((String)"#username");
    }

    public SelenideElement passwordField() {
        return Selenide.$((String)"#password");
    }

    public SelenideElement submitButton() {
        return Selenide.$((String)"#submit-button");
    }

    public void submit() {
        ElementUtils.clickableClick(this.submitButton());
    }

    public StartPage loginAs(String username, String password) {
        return this.loginAs(username, password, null);
    }

    public StartPage loginAs(String username, String password, String affinity) {
        StartPage startPage = new StartPage();
        if (affinity != null) {
            Helpers.setAffinityCookie(affinity);
        }
        if (!LoginPage.isLoggedIn()) {
            this.open();
            if (IMS_USER != null) {
                ExpectNav.on(IMS_LOGIN_BUTTON::click);
                IMS_USERNAME_FIELD.should(new Condition[]{Condition.visible}).sendKeys(new CharSequence[]{IMS_USER, Keys.ENTER});
                ExpectNav.on(() -> {
                    IMS_PASSWORD_FIELD.should(new Condition[]{Condition.visible}).setValue(IMS_PASSWORD);
                    IMS_PASSWORD_FIELD.should(new Condition[]{Condition.visible}).sendKeys(new CharSequence[]{Keys.ENTER});
                });
                startPage.waitReady();
                Helpers.setImpersonateCookie(username);
                Selenide.refresh();
            } else {
                if (this.isCloudLogin()) {
                    ElementUtils.clickableClick(ACCORDION_ON_CLOUD);
                }
                this.usernameField().setValue(username);
                this.passwordField().setValue(password);
                ExpectNav.on(this::submit);
            }
            startPage.waitReady();
        } else {
            startPage.open();
        }
        return startPage;
    }
}

