/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.pageobject.granite;

import com.adobe.cq.testing.selenium.pageobject.granite.ShellPage;
import com.adobe.cq.testing.selenium.pageobject.granite.ViewType;
import com.adobe.cq.testing.selenium.pagewidgets.Helpers;
import com.adobe.cq.testing.selenium.pagewidgets.I18N;
import com.adobe.cq.testing.selenium.pagewidgets.coral.CoralActionBar;
import com.adobe.cq.testing.selenium.pagewidgets.coral.CoralCycleButton;
import com.adobe.cq.testing.selenium.pagewidgets.coral.CoralQuickActions;
import com.adobe.cq.testing.selenium.pagewidgets.coral.CoralReady;
import com.adobe.cq.testing.selenium.pagewidgets.coral.CoralSelectList;
import com.adobe.cq.testing.selenium.pagewidgets.cq.EnumRail;
import com.adobe.cq.testing.selenium.pagewidgets.granite.Breadcrumbs;
import com.adobe.cq.testing.selenium.pagewidgets.granite.Collection;
import com.adobe.cq.testing.selenium.pagewidgets.granite.CollectionSwitcher;
import com.adobe.cq.testing.selenium.pagewidgets.granite.Masonry;
import com.adobe.cq.testing.selenium.pagewidgets.granite.Rail;
import com.adobe.cq.testing.selenium.pagewidgets.granite.Table;
import com.adobe.cq.testing.selenium.pagewidgets.granite.columnview.ColumnView;
import java.util.EnumMap;

public class CollectionPage
extends ShellPage {
    private static final String BASE_COLLECTION_SELECTOR = ".foundation-collection";
    private static final CoralCycleButton RAIL_CYCLE_BUTTON = new CoralCycleButton("[id=\"shell-collectionpage-rail-toggle\"]");
    private static final long NETWORK_IDLE_INTERVAL = 250L;
    private final CoralActionBar actionbarElement;
    private final CoralQuickActions quickactions;
    private EnumMap<ViewType, Collection> viewIconToWrapperClassMap = new EnumMap(ViewType.class);
    private Collection currentCollectionInstance;

    public CollectionPage(String path) {
        super(null, path);
        this.viewIconToWrapperClassMap.put(ViewType.CARD, new Masonry(BASE_COLLECTION_SELECTOR));
        this.viewIconToWrapperClassMap.put(ViewType.LIST, new Table(BASE_COLLECTION_SELECTOR));
        this.viewIconToWrapperClassMap.put(ViewType.COLUMN, new ColumnView(BASE_COLLECTION_SELECTOR));
        this.actionbarElement = new CoralActionBar();
        this.quickactions = new CoralQuickActions();
    }

    public Collection collection() {
        if (this.currentCollectionInstance == null) {
            throw new IllegalStateException("Please call switchToView(ViewType) first");
        }
        return this.currentCollectionInstance;
    }

    public Rail leftRail() {
        return new Rail();
    }

    public CoralCycleButton railToggle() {
        return RAIL_CYCLE_BUTTON;
    }

    public Breadcrumbs breadcrumbs() {
        return new Breadcrumbs();
    }

    public CoralActionBar actionBar() {
        return this.actionbarElement;
    }

    public CoralQuickActions quickActions() {
        return this.quickactions;
    }

    public void openRail(EnumRail railtype) {
        this.railToggle().click();
        this.railToggle().selectList().selectByLabel(I18N.geti18nString(railtype.getI18nTitle()));
        if (railtype.getPanelName() != null) {
            Helpers.waitForElementAnimationFinished(this.leftRail().getCssSelector());
        }
    }

    private void switchToView(ViewType viewType, Collection viewCollection) {
        String collectionSelector = viewCollection.getCssSelector();
        boolean viewChanged = new CollectionSwitcher().switchToView(viewType);
        if (viewChanged) {
            Helpers.waitNetworkIdled(250L);
            CoralReady.waitCoralReady(collectionSelector);
        }
        this.currentCollectionInstance = viewCollection;
    }

    public CollectionPage switchToView(ViewType viewType) {
        Collection viewCollection = this.viewIconToWrapperClassMap.get((Object)viewType);
        if (viewCollection == null) {
            throw new UnsupportedOperationException("Unsupported view");
        }
        this.switchToView(viewType, viewCollection);
        return this;
    }

    public void setCurrentView(ViewType viewType) {
        this.currentCollectionInstance = this.viewIconToWrapperClassMap.get((Object)viewType);
    }

    public boolean hasRailItem(String name) {
        CoralSelectList selectList = this.railToggle().selectList();
        return selectList.hasItemBySelector(String.format(" [data-granite-toggleable-control-name='%s']", name));
    }
}

