/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.polling;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.Iterator;
import java.util.concurrent.TimeoutException;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingClient;
import org.apache.sling.testing.clients.util.JsonUtils;
import org.apache.sling.testing.clients.util.poller.Polling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventPoller
extends Polling {
    private static final Logger LOG = LoggerFactory.getLogger(EventPoller.class);
    private static final String EVENT_URL = "/system/console/events.json";
    private String topic;
    private JsonNode events;
    private String path;
    private SlingClient client;
    private long since;

    public EventPoller(SlingClient client, String topic, String path, long since) {
        this.topic = topic;
        this.path = path;
        this.since = since;
        this.client = client;
    }

    public Boolean call() throws ClientException {
        this.events = EventPoller.getEventsSince(this.client, this.since);
        return EventPoller.containsEvent(this.events, this.topic, this.path);
    }

    public static long getLatestEventTimestamp(SlingClient client) throws ClientException {
        JsonNode eventData = JsonUtils.getJsonNodeFromString((String)client.doGet(EVENT_URL, new int[]{200}).getContent());
        JsonNode allEvents = eventData.get("data");
        long mostRecent = 0L;
        Iterator it = allEvents.elements();
        while (it.hasNext()) {
            JsonNode event = (JsonNode)it.next();
            long received = event.get("received").longValue();
            if (received <= mostRecent) continue;
            mostRecent = received;
        }
        return mostRecent;
    }

    public static JsonNode getEventsSince(SlingClient client, long timestamp) throws ClientException {
        JsonNode eventData = JsonUtils.getJsonNodeFromString((String)client.doGet(EVENT_URL, new int[]{200}).getContent());
        JsonNode allEvents = eventData.get("data");
        ArrayNode events = new ObjectMapper().createArrayNode();
        Iterator it = allEvents.elements();
        while (it.hasNext()) {
            JsonNode event = (JsonNode)it.next();
            if (event.get("received").longValue() <= timestamp) continue;
            events.add(event);
        }
        return events;
    }

    public static boolean containsEvent(JsonNode events, String topic, String path) {
        Iterator it = events.elements();
        while (it.hasNext()) {
            JsonNode event = (JsonNode)it.next();
            if (!event.get("topic").textValue().equals(topic)) continue;
            JsonNode properties = event.get("properties");
            JsonNode eventPath = properties.get("path");
            if (eventPath != null && eventPath.textValue().equals(path)) {
                return true;
            }
            JsonNode paths = properties.get("paths");
            if (paths == null) continue;
            Iterator it1 = paths.elements();
            while (it1.hasNext()) {
                JsonNode otherPath = (JsonNode)it1.next();
                if (otherPath == null || !otherPath.textValue().equals(path)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean checkEventOccurrence(SlingClient client, String topic, String path, long since) throws InterruptedException {
        EventPoller poller = new EventPoller(client, topic, path, since);
        try {
            poller.poll(5000L, 100L);
            return true;
        }
        catch (TimeoutException e) {
            LOG.warn("Interrupted while polling for event " + topic + " at " + path + ".", (Throwable)e);
            return false;
        }
    }
}

