/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.client.topology;

import com.adobe.cq.testing.client.CQClient;
import com.adobe.cq.testing.client.TopologyClient;
import java.util.Set;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingClient;
import org.apache.sling.testing.clients.util.config.InstanceConfig;
import org.apache.sling.testing.clients.util.config.InstanceConfigException;

public class TopologyInstanceConfig
implements InstanceConfig {
    TopologyClient client;
    Set<String> topology;

    public <T extends SlingClient> TopologyInstanceConfig(T client) throws InstanceConfigException {
        try {
            this.client = (TopologyClient)client.adaptTo(TopologyClient.class);
        }
        catch (ClientException e) {
            throw new InstanceConfigException("Couldn't set client", (Throwable)e);
        }
        this.save();
    }

    public <T extends CQClient> TopologyClient setClient(T client) throws InstanceConfigException {
        try {
            this.client = (TopologyClient)client.adaptTo(TopologyClient.class);
        }
        catch (ClientException e) {
            throw new InstanceConfigException("Couldn't set client", (Throwable)e);
        }
        return this.client;
    }

    public TopologyClient getClient() {
        return this.client;
    }

    public TopologyInstanceConfig save() throws InstanceConfigException {
        try {
            try {
                this.topology = this.client.getConnectorUrlsWithWait(300L);
            }
            catch (InterruptedException e) {
                throw new InstanceConfigException("Fetching the topology connector URLs interrupted", (Throwable)e);
            }
        }
        catch (ClientException e) {
            throw new InstanceConfigException("Fetching the topology connector URLs failed", (Throwable)e);
        }
        return this;
    }

    public TopologyInstanceConfig restore() throws InstanceConfigException {
        try {
            this.client.setConnectorUrlsWithWait(this.topology, 300L);
        }
        catch (ClientException e) {
            throw new InstanceConfigException("Setting the topology connector URLs failed", (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new InstanceConfigException("Setting the topology connector URLs was interrupted", (Throwable)e);
        }
        return this;
    }
}

