/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.client.security;

import com.adobe.cq.testing.client.CQClient;
import com.adobe.cq.testing.client.CQSecurityClient;
import com.adobe.cq.testing.client.SecurityClient;
import com.adobe.cq.testing.client.security.Group;
import com.adobe.cq.testing.client.security.NewRandomUserInstanceConfig;
import com.adobe.cq.testing.client.security.User;
import com.adobe.cq.testing.client.security.UserRule;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.apache.sling.testing.clients.SlingClient;
import org.apache.sling.testing.clients.util.config.InstanceConfig;
import org.apache.sling.testing.clients.util.config.InstanceConfigCache;
import org.apache.sling.testing.clients.util.config.impl.InstanceConfigCacheImpl;
import org.apache.sling.testing.clients.util.poller.Polling;
import org.apache.sling.testing.junit.rules.instance.Instance;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class CreateUserRule
extends ExternalResource
implements UserRule {
    private static final Logger LOG = LoggerFactory.getLogger(CreateUserRule.class);
    private Instance instanceRule;
    private CQSecurityClient adminAuthor;
    private final String[] groups;
    private ThreadLocal<CQClient> userClient = new ThreadLocal();
    private ThreadLocal<InstanceConfigCache> usersToDelete = new ThreadLocal();

    public CreateUserRule(Instance instanceRule, String ... groups) {
        this.instanceRule = instanceRule;
        this.groups = groups;
    }

    protected void before() throws Throwable {
        this.adminAuthor = (CQSecurityClient)this.instanceRule.getAdminClient(CQSecurityClient.class);
        Group[] assignedGroups = (Group[])Arrays.stream(this.groups).map(this::getGroup).toArray(Group[]::new);
        UserCreateCallable c = new UserCreateCallable(this.adminAuthor, assignedGroups);
        Polling p = new Polling((Callable)c);
        try {
            p.poll(10000L, 1000L);
        }
        catch (TimeoutException e) {
            LOG.error("Could not create user. List of exceptions: " + p.getExceptions(), (Throwable)e);
            this.usersToDelete.set(c.getUserConfigs());
            this.after();
            throw e;
        }
        this.usersToDelete.set(c.getUserConfigs());
        Thread.sleep(500L);
        new Polling(() -> c.getSuccessfulUserConfig().getUser().exists()).poll(5000L, 500L);
        this.userClient.set(new CQClient(this.adminAuthor.getUrl(), c.getUsername(), c.getPassword()));
    }

    protected void after() {
        LOG.info("Cleaning up all attempted user creations");
        for (InstanceConfig userConfig : this.usersToDelete.get()) {
            if (!(userConfig instanceof NewRandomUserInstanceConfig)) continue;
            NewRandomUserInstanceConfig cfg = (NewRandomUserInstanceConfig)userConfig;
            try {
                new Polling(() -> {
                    cfg.restore();
                    return !User.exists(this.adminAuthor, cfg.getUsername());
                }).poll(5000L, 500L);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public CQClient getClient() {
        return this.userClient.get();
    }

    public Supplier<SlingClient> getClientSupplier() {
        class ClientSupplier
        implements Supplier<SlingClient> {
            private final CreateUserRule userRule;

            public ClientSupplier(CreateUserRule userRule) {
                this.userRule = userRule;
            }

            @Override
            public SlingClient get() {
                return this.userRule.getClient();
            }
        }
        return new ClientSupplier(this);
    }

    private Group getGroup(String groupName) {
        try {
            return new Group(this.adminAuthor, groupName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private class UserCreateCallable
    implements Callable<Boolean> {
        private final Group[] assignedGroups;
        private final InstanceConfigCache userConfigs = new InstanceConfigCacheImpl();
        private final SecurityClient client;
        private NewRandomUserInstanceConfig successfulUserConfig;

        public UserCreateCallable(SecurityClient client, Group[] assignedGroups) {
            this.client = client;
            this.assignedGroups = assignedGroups;
        }

        public String getUsername() {
            return null != this.successfulUserConfig ? this.successfulUserConfig.getUsername() : null;
        }

        public String getPassword() {
            return null != this.successfulUserConfig ? this.successfulUserConfig.getPassword() : null;
        }

        public InstanceConfigCache getUserConfigs() {
            return this.userConfigs;
        }

        public NewRandomUserInstanceConfig getSuccessfulUserConfig() {
            return this.successfulUserConfig;
        }

        @Override
        public Boolean call() throws Exception {
            NewRandomUserInstanceConfig config = new NewRandomUserInstanceConfig(this.client, this.assignedGroups);
            this.userConfigs.add((Object)config);
            config.save();
            this.successfulUserConfig = config;
            return true;
        }
    }
}

