/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.client.offloading;

import com.adobe.cq.testing.client.CQClient;
import com.adobe.cq.testing.client.offloading.OffloadingInstanceConfiguration;
import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.apache.http.HttpEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingClientConfig;
import org.apache.sling.testing.clients.SlingHttpResponse;
import org.apache.sling.testing.clients.util.FormEntityBuilder;
import org.apache.sling.testing.clients.util.JsonUtils;
import org.apache.sling.testing.clients.util.poller.Polling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OffloadingBrowserClient
extends CQClient {
    public static final Logger LOG = LoggerFactory.getLogger(OffloadingBrowserClient.class);
    public static final String OFFLOADING_BROWSER_JSON_LIST_URL = "/libs/granite/offloading/content/view/views/wrapper/items/servletComponentPlaceholder.list.json";
    public static final String OFFLOADING_CONFIG_URL = "/libs/granite/offloading/content/view/views/wrapper/items/servletComponentPlaceholder.config.html";
    public static final String SLING_ID_KEY = "slingID";
    public static final String IP_KEY = "ip";
    public static final String PORT_KEY = "port";
    public static final String CLUSTER_KEY = "cluster";
    public static final String OFFLOADING_TOPIC = "com/adobe/granite/workflow/offloading";

    public OffloadingBrowserClient(CloseableHttpClient http, SlingClientConfig config) throws ClientException {
        super(http, config);
    }

    public OffloadingBrowserClient(URI serverUrl, String user, String password) throws ClientException {
        super(serverUrl, user, password);
    }

    public Set<OffloadingInstanceConfiguration> getAllInstances() throws ClientException {
        HashSet<OffloadingInstanceConfiguration> instances = new HashSet<OffloadingInstanceConfiguration>();
        SlingHttpResponse re = this.doGet(OFFLOADING_BROWSER_JSON_LIST_URL, new int[]{200});
        JsonNode json = JsonUtils.getJsonNodeFromString((String)re.getContent());
        JsonNode topics = json.get("topics");
        for (JsonNode topicNode : topics) {
            JsonNode instancesNode = topicNode.get("instances");
            Set<OffloadingInstanceConfiguration> topicInstances = this.instancesFromJSONArray(instancesNode, topicNode.get("topic").textValue().trim());
            instances.addAll(topicInstances);
            for (OffloadingInstanceConfiguration instanceConfiguration : instances) {
                for (OffloadingInstanceConfiguration topicInstanceConfiguration : topicInstances) {
                    if (!topicInstanceConfiguration.equals(instanceConfiguration)) continue;
                    instanceConfiguration.topics.addAll(topicInstanceConfiguration.topics);
                }
            }
        }
        return instances;
    }

    public OffloadingInstanceConfiguration getInstance(String slingId) throws ClientException {
        Set<OffloadingInstanceConfiguration> instances = this.getAllInstances();
        for (OffloadingInstanceConfiguration instance : instances) {
            if (!instance.slingId.equals(slingId)) continue;
            return instance;
        }
        return null;
    }

    public void enableDisableTopic(String slingId, String topic, boolean enable) throws ClientException {
        FormEntityBuilder form = FormEntityBuilder.create();
        form.addParameter(SLING_ID_KEY, slingId);
        form.addParameter("config:" + topic, enable ? "enable" : "disable");
        LOG.debug("URL:{}, slingId:{}, topic:{}, enable: {}", new Object[]{OFFLOADING_CONFIG_URL, slingId, topic, enable});
        this.doPost(OFFLOADING_CONFIG_URL, (HttpEntity)form.build(), new int[]{200});
    }

    public void enableDisableTopicWithWait(final String slingId, final String topic, final boolean enable, long timeout) throws ClientException, InterruptedException {
        this.enableDisableTopic(slingId, topic, enable);
        try {
            new Polling(this){
                final /* synthetic */ OffloadingBrowserClient this$0;
                {
                    this.this$0 = this$0;
                }

                public Boolean call() throws Exception {
                    OffloadingInstanceConfiguration instance = this.this$0.getInstance(slingId);
                    return enable && instance.topics.contains(topic) || !enable && !instance.topics.contains(topic);
                }
            }.poll(timeout, 100L);
        }
        catch (TimeoutException e) {
            throw new ClientException(enable ? "Enabling" : "Disabling the topic did not register in the Offloading Browser.");
        }
    }

    private Set<OffloadingInstanceConfiguration> instancesFromJSONArray(JsonNode instancesNode, String topicName) {
        HashSet<OffloadingInstanceConfiguration> instances = new HashSet<OffloadingInstanceConfiguration>();
        for (JsonNode instanceNode : instancesNode) {
            OffloadingInstanceConfiguration instance = new OffloadingInstanceConfiguration();
            instance.slingId = instanceNode.get(SLING_ID_KEY).textValue();
            instance.ip = instanceNode.get(IP_KEY).textValue();
            instance.port = instanceNode.get(PORT_KEY).textValue();
            instance.cluster = instanceNode.get(CLUSTER_KEY).textValue();
            if (instanceNode.get("topicEnabled") != null && instanceNode.get("topicEnabled").booleanValue()) {
                instance.topics.add(topicName);
            }
            instances.add(instance);
        }
        return instances;
    }
}

