/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.client.jobs;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class JobQueueStat {
    String queueName;
    long startTime;
    long lastActivated;
    long lastFinished;
    int queuedJobs;
    int activeJobs;
    int finishedJobs;
    int failedJobs;
    int cancelledJobs;
    int avgProcessingTime;
    int avgWaitingTime;
    String type;
    List<String> topics;
    int maxParallel;
    int maxRetries;
    int retryDelay;
    String priority;
    String statusInfo;

    public String getQueueName() {
        return this.queueName;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getLastActivated() {
        return this.lastActivated;
    }

    public long getLastFinished() {
        return this.lastFinished;
    }

    public int getQueuedJobs() {
        return this.queuedJobs;
    }

    public int getActiveJobs() {
        return this.activeJobs;
    }

    public int getFinishedJobs() {
        return this.finishedJobs;
    }

    public int getFailedJobs() {
        return this.failedJobs;
    }

    public int getCancelledJobs() {
        return this.cancelledJobs;
    }

    public int getAvgProcessingTime() {
        return this.avgProcessingTime;
    }

    public int getAvgWaitingTime() {
        return this.avgWaitingTime;
    }

    public String getType() {
        return this.type;
    }

    public List<String> getTopics() {
        return this.topics;
    }

    public int getMaxParallel() {
        return this.maxParallel;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public int getRetryDelay() {
        return this.retryDelay;
    }

    public String getPriority() {
        return this.priority;
    }

    public String getStatusInfo() {
        return this.statusInfo;
    }

    public JobQueueStat(String queueName, long startTime, long lastActivated, long lastFinished, int queuedJobs, int activeJobs, int finishedJobs, int failedJobs, int cancelledJobs, int avgProcessingTime, int avgWaitingTime, String type, List<String> topics, int maxParallel, int maxRetries, int retryDelay, String priority, String statusInfo) {
        this.queueName = queueName;
        this.startTime = startTime;
        this.lastActivated = lastActivated;
        this.lastFinished = lastFinished;
        this.queuedJobs = queuedJobs;
        this.activeJobs = activeJobs;
        this.finishedJobs = finishedJobs;
        this.failedJobs = failedJobs;
        this.cancelledJobs = cancelledJobs;
        this.avgProcessingTime = avgProcessingTime;
        this.avgWaitingTime = avgWaitingTime;
        this.type = type;
        this.topics = topics;
        this.maxParallel = maxParallel;
        this.maxRetries = maxRetries;
        this.retryDelay = retryDelay;
        this.priority = priority;
        this.statusInfo = statusInfo;
    }

    public JobQueueStat(String queueName, JsonNode jobJson) {
        this.queueName = queueName;
        JsonNode statistics = jobJson.get("statistics");
        JsonNode configuration = jobJson.get("configuration");
        this.startTime = statistics.get("start_time").longValue();
        this.lastActivated = statistics.get("last_activated").longValue();
        this.lastFinished = statistics.get("last_finished").longValue();
        this.queuedJobs = statistics.get("queued_jobs").intValue();
        this.activeJobs = statistics.get("active_jobs").intValue();
        this.finishedJobs = statistics.get("finished_jobs").intValue();
        this.failedJobs = statistics.get("failed_jobs").intValue();
        this.cancelledJobs = statistics.get("cancelled_jobs").intValue();
        this.avgProcessingTime = statistics.get("avg_processing_time").intValue();
        this.avgWaitingTime = statistics.get("avg_waiting_time").intValue();
        this.type = configuration.get("type").textValue();
        this.topics = new ArrayList<String>();
        Iterator topicsIterator = configuration.get("topics").elements();
        while (topicsIterator.hasNext()) {
            this.topics.add(((JsonNode)topicsIterator.next()).textValue());
        }
        this.maxParallel = configuration.get("max_parallel").intValue();
        this.maxRetries = configuration.get("max_retries").intValue();
        this.retryDelay = configuration.get("retry_delay").intValue();
        this.priority = configuration.get("priority").textValue();
        this.statusInfo = jobJson.get("status_info").textValue();
    }
}

