/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.client.components.foundation.form;

import com.adobe.cq.testing.client.ComponentClient;
import com.adobe.cq.testing.client.components.AbstractComponent;
import com.adobe.cq.testing.client.components.foundation.form.AbstractFormFieldComponent;
import com.adobe.cq.testing.client.components.foundation.form.End;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingHttpResponse;
import org.apache.sling.testing.clients.util.FormEntityBuilder;

public class Start
extends AbstractComponent {
    public static final String RESOURCE_TYPE = "foundation/components/form/start";
    public static final String PROP_REDIRECT = "redirect";
    public static final String PROP_WORKFLOW = "workflowModel";
    public static final String PROP_ACTION_TYPE = "actionType";
    public static final String PROP_FORM_ID = "formid";
    public static final String PROP_CLIENT_VALIDATION = "clientValidation";
    public static final String PROP_VALIDATION_RT = "validationRT";
    public static final String OPT_ACTION_TYPE_STORE = "foundation/components/form/actions/store";
    public static final String PROP_ACTION_STORE_CONTENT_PATH = "action";
    public static final Charset CHARSET_UTF8 = Charset.forName("UTF-8");
    private End endComponent = null;
    private HashMap<String, Object> formValues = new HashMap();

    public Start(ComponentClient client, String pagePath, String location, String nameHint) {
        super(client, pagePath, location, nameHint);
    }

    @Override
    public String getResourceType() {
        return RESOURCE_TYPE;
    }

    @Override
    public FormEntityBuilder getCreateFormEntity(String order) {
        return super.getCreateFormEntity(order).addParameter("parentResourceType", "foundation/components/parsys");
    }

    @Override
    public SlingHttpResponse create(String order, int ... expectedStatus) throws ClientException, InterruptedException {
        SlingHttpResponse res = super.create(order, expectedStatus);
        this.endComponent = (End)this.getNext();
        this.endComponent.setStartComponent(this);
        return res;
    }

    public End getFormEndComponent() {
        return this.endComponent;
    }

    public void setRedirect(String pageHandle) {
        this.setProperty(PROP_REDIRECT, pageHandle);
    }

    public void setWorkflowModel(String modelHandle) {
        this.setProperty(PROP_WORKFLOW, modelHandle + "/jcr:content/model");
    }

    public void setActionType(String actionTypeHandle) {
        this.setProperty(PROP_ACTION_TYPE, actionTypeHandle);
    }

    public void setFormId(String formId) {
        this.setProperty(PROP_FORM_ID, formId);
    }

    public String getFormId() {
        return this.getPropertyAsString(PROP_FORM_ID);
    }

    public void setClientValidation(boolean validate) {
        if (validate) {
            this.setProperty(PROP_CLIENT_VALIDATION, "true");
        } else {
            this.setProperty("clientValidation@Delete", "true");
        }
    }

    public void setClientValidationResourceType(String resourceType) {
        this.setProperty(PROP_VALIDATION_RT, resourceType);
    }

    public void setFormActionStore(String contentPath) {
        this.setProperty(PROP_ACTION_TYPE, OPT_ACTION_TYPE_STORE);
        this.setProperty(PROP_ACTION_STORE_CONTENT_PATH, contentPath);
    }

    public String getFormActionStore() throws ClientException, InterruptedException {
        try {
            this.client.waitExists(this.getComponentPath(), 60000L, 100L);
        }
        catch (TimeoutException e) {
            throw new ClientException("Component does not exist " + this.getComponentPath(), (Throwable)e);
        }
        JsonNode node = this.client.doGetJson(this.getComponentPath(), 1, new int[0]);
        JsonNode action = node.get(PROP_ACTION_STORE_CONTENT_PATH);
        return action.asText();
    }

    public void submit() throws ClientException, InterruptedException {
        this.client.doPost(this.getPagePath() + ".html", this.createMultipartEntity(), new int[0]);
    }

    public SlingHttpResponse submit2() throws ClientException, InterruptedException {
        return this.client.doPost(this.getPagePath() + ".html", this.createMultipartEntity(), new int[0]);
    }

    public HttpEntity createMultipartEntity() throws ClientException, InterruptedException {
        String redirect;
        ContentType textContentType = ContentType.create((String)"text/plain", (Charset)Consts.UTF_8);
        MultipartEntityBuilder meb = MultipartEntityBuilder.create();
        Start next = this;
        String formId = next.getPropertyAsString(PROP_FORM_ID);
        if (formId != null) {
            meb.addTextBody(":formid", formId, textContentType);
        }
        if ((redirect = next.getPropertyAsString(PROP_REDIRECT)) != null) {
            meb.addTextBody(":redirect", redirect, textContentType);
        }
        meb.addTextBody(":formstart", this.getComponentPath(), textContentType);
        meb.addTextBody(":_charset_", "UTF-8", textContentType);
        meb.addTextBody(":Submit", "Submit", textContentType);
        while (next.getNext() != null && !(next = next.getNext()).getName().equals(this.getFormEndComponent().getName())) {
            Object value;
            if (!(next instanceof AbstractFormFieldComponent) || (value = this.formValues.get(next.getName())) == null) continue;
            String fieldName = ((AbstractFormFieldComponent)((Object)next)).getElementName();
            if (value instanceof String) {
                meb.addTextBody(fieldName, (String)value, textContentType);
                continue;
            }
            if (value instanceof String[]) {
                String[] values;
                for (String v : values = (String[])value) {
                    meb.addTextBody(fieldName, v, textContentType);
                }
                continue;
            }
            if (value instanceof File) {
                String name = ((File)value).getName();
                FileBody fileBody = new FileBody((File)value);
                meb.addPart(name, (ContentBody)fileBody);
                continue;
            }
            if (!(value instanceof Map)) continue;
            for (Object o : ((Map)value).keySet()) {
                String[] values;
                String key = (String)o;
                Object v = ((Map)value).get(key);
                if (v instanceof String) {
                    meb.addTextBody(key, (String)v, textContentType);
                    continue;
                }
                if (!(v instanceof String[])) continue;
                for (String val : values = (String[])v) {
                    meb.addTextBody(key, val, textContentType);
                }
            }
        }
        if (!next.getName().equals(this.getFormEndComponent().getName())) {
            throw new ClientException("Start and End Form Components do not match, not submitting!");
        }
        return meb.build();
    }

    public void setFormValueToSubmit(String componentName, Object value) {
        if (value == null) {
            this.formValues.remove(componentName);
        }
        this.formValues.put(componentName, value);
    }

    public String getFormValue(String componentName) throws ClientException {
        Object value = this.formValues.get(componentName);
        if (value instanceof String) {
            return (String)value;
        }
        throw new ClientException("Requested Form Value is not a String!");
    }
}

