/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.client;

import com.adobe.cq.testing.client.CQClient;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingClientConfig;
import org.apache.sling.testing.clients.SlingHttpResponse;
import org.apache.sling.testing.clients.util.FormEntityBuilder;
import org.apache.sling.testing.clients.util.HttpUtils;
import org.apache.sling.testing.clients.util.JsonUtils;
import org.apache.sling.testing.clients.util.poller.Polling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyClient
extends CQClient {
    private static final Logger LOG = LoggerFactory.getLogger(TopologyClient.class);
    public static final String DEFAULT_CONNECTOR_PATH = "/libs/sling/topology/connector";
    public static final String QE_TOPOLOGY_SERVLET_PATH = "/libs/granite/qe/topology";
    public static final String CONNECTOR_URLS_PATH = "connectorurls";
    public static final String CLUSTER_VIEW_PATH = "clusterview";
    public static final String UTF_8 = "UTF-8";
    public static final String QE_SLINGSETTINGS_SERVLET_PATH = "/libs/granite/qe/slingsettings";

    public TopologyClient(CloseableHttpClient http, SlingClientConfig config) throws ClientException {
        super(http, config);
    }

    public TopologyClient(URI serverUrl, String user, String password) throws ClientException {
        super(serverUrl, user, password);
    }

    public boolean joinTopology(String baseUrl) throws ClientException {
        return this.joinTopology(baseUrl, DEFAULT_CONNECTOR_PATH);
    }

    public boolean joinTopology(String baseUrl, String connectorPath) throws ClientException {
        Set<String> newConnectorUrlsList = this.AddConnUrl(baseUrl, connectorPath);
        this.setConnectorUrls(newConnectorUrlsList);
        return true;
    }

    private Set<String> AddConnUrl(String baseUrl, String connectorPath) throws ClientException {
        URL connectorUrl;
        URL bUrl;
        try {
            bUrl = new URL(baseUrl);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("baseUrl is not a valid URL", e);
        }
        try {
            connectorUrl = new URL(bUrl, connectorPath);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Could not create connector URL from server URL and connector path", e);
        }
        String connectorUrlString = connectorUrl.toString();
        Set<String> newConnectorUrlsList = this.getConnectorUrls();
        newConnectorUrlsList.add(connectorUrlString);
        return newConnectorUrlsList;
    }

    public boolean joinTopologyWithWait(String baseUrl, String connectorPath, long timeout) throws ClientException, InterruptedException {
        Set<String> newConnectorUrlsList = this.AddConnUrl(baseUrl, connectorPath);
        this.setConnectorUrlsWithWait(newConnectorUrlsList, timeout);
        return true;
    }

    public boolean joinTopologyWithWait(String baseUrl, long timeout) throws ClientException, InterruptedException {
        return this.joinTopologyWithWait(baseUrl, DEFAULT_CONNECTOR_PATH, timeout);
    }

    public boolean leaveTopology(String baseUrl) throws ClientException {
        return this.leaveTopology(baseUrl, DEFAULT_CONNECTOR_PATH);
    }

    public boolean leaveTopology(String baseUrl, String connectorPath) throws ClientException {
        Set<String> newConnectorUrlsList = this.removeConnUrl(baseUrl, connectorPath);
        this.setConnectorUrls(newConnectorUrlsList);
        return true;
    }

    private Set<String> removeConnUrl(String baseUrl, String connectorPath) throws ClientException {
        URL connectorUrl;
        URL bUrl;
        try {
            bUrl = new URL(baseUrl);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("baseUrl is not a valid URL", e);
        }
        try {
            connectorUrl = new URL(bUrl, connectorPath);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Could not create connector URL from server URL and connector path", e);
        }
        Set<String> newConnectorUrlsList = this.getConnectorUrls();
        newConnectorUrlsList.remove(connectorUrl.toString());
        return newConnectorUrlsList;
    }

    public boolean leaveTopologyWithWait(String baseUrl, String connectorPath, long timeout) throws ClientException, InterruptedException {
        Set<String> newConnectorUrlsList = this.removeConnUrl(baseUrl, connectorPath);
        this.setConnectorUrlsWithWait(newConnectorUrlsList, timeout);
        return true;
    }

    public boolean leaveTopologyWithWait(String baseUrl, long timeout) throws ClientException, InterruptedException {
        return this.leaveTopologyWithWait(baseUrl, DEFAULT_CONNECTOR_PATH, timeout);
    }

    public Set<String> getConnectorUrls() throws ClientException {
        JsonNode json = this.getConnectorUrlsJson(new int[0]);
        return this.parseConnectorUrls(json);
    }

    public Set<String> getConnectorUrlsWithWait(long timeout) throws ClientException, InterruptedException {
        class TopologyPoller
        extends Polling {
            public JsonNode json = null;
            public Set<String> connectorUrls = null;

            TopologyPoller() {
            }

            public Boolean call() throws Exception {
                this.json = TopologyClient.this.getConnectorUrlsJson(new int[0]);
                if (null != this.json && "ok".equals(this.json.get("status").textValue()) && this.json.get("is_current").booleanValue()) {
                    this.connectorUrls = TopologyClient.this.parseConnectorUrls(this.json);
                    return true;
                }
                return false;
            }
        }
        TopologyPoller poller = new TopologyPoller();
        try {
            poller.poll(timeout, 1000L);
        }
        catch (TimeoutException e) {
            throw new ClientException("Failed to retrieve connector urls in " + poller.getWaited() + " ms", (Throwable)e);
        }
        return poller.connectorUrls;
    }

    private JsonNode getConnectorUrlsJson(int ... statusCode) throws ClientException {
        SlingHttpResponse response = this.doGet("/libs/granite/qe/topology.connectorurls.json", HttpUtils.getExpectedStatus((int)200, (int[])statusCode));
        return JsonUtils.getJsonNodeFromString((String)response.getContent());
    }

    private Set<String> parseConnectorUrls(JsonNode json) throws ClientException {
        HashSet<String> connectorUrls = new HashSet<String>(5);
        Iterator connectorListIterator = json.get("data").elements();
        while (connectorListIterator.hasNext()) {
            String connUrl;
            try {
                connUrl = URLDecoder.decode(((JsonNode)connectorListIterator.next()).textValue(), UTF_8);
            }
            catch (UnsupportedEncodingException e) {
                throw new ClientException("Could not decode URL", (Throwable)e);
            }
            if (null == connUrl || connUrl.isEmpty()) continue;
            connectorUrls.add(connUrl);
        }
        return connectorUrls;
    }

    public void setConnectorUrls(Set<String> connectorUrlsList) throws ClientException {
        String connectorUrls = StringUtils.join((Object[])connectorUrlsList.toArray(), (String)",");
        FormEntityBuilder feb = FormEntityBuilder.create().addParameter("connectorUrls", connectorUrls);
        this.doPost("/libs/granite/qe/topology.connectorurls.json", (HttpEntity)feb.build(), new int[]{200});
    }

    public void setConnectorUrlsWithWait(Set<String> connectorUrlsList, long timeout) throws ClientException, InterruptedException {
        this.setConnectorUrls(connectorUrlsList);
        this.getConnectorUrlsWithWait(timeout);
    }

    public String getSlingId() throws ClientException {
        SlingHttpResponse response = this.doGet("/libs/granite/qe/slingsettings.sling_id.json", new int[]{200});
        JsonNode json = JsonUtils.getJsonNodeFromString((String)response.getContent());
        return json.get("data").get("sling_id").textValue();
    }
}

