/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.junit.rules;

import com.adobe.cq.testing.client.CQClient;
import com.adobe.cq.testing.client.CQSecurityClient;
import com.adobe.cq.testing.client.SecurityClient;
import com.adobe.cq.testing.client.security.Authorizable;
import com.adobe.cq.testing.client.security.Group;
import com.adobe.cq.testing.client.security.User;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingClient;
import org.apache.sling.testing.clients.util.poller.Polling;
import org.junit.rules.ExternalResource;
import org.ops4j.lang.NullArgumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemporaryUser
extends ExternalResource {
    private static final Logger LOG = LoggerFactory.getLogger(TemporaryUser.class);
    private final Supplier<SlingClient> creatorSupplier;
    private final String[] groups;
    private final ThreadLocal<CQClient> userClient;
    private final ThreadLocal<List<String>> usersToDelete;

    public TemporaryUser(Supplier<SlingClient> creatorSupplier, String ... groups) {
        if (creatorSupplier == null) {
            throw new NullArgumentException("creatorSupplier is null");
        }
        this.creatorSupplier = creatorSupplier;
        this.groups = groups;
        this.userClient = new ThreadLocal();
        this.usersToDelete = ThreadLocal.withInitial(ArrayList::new);
    }

    public CQClient getClient() {
        return this.userClient.get();
    }

    public Supplier<SlingClient> getClientSupplier() {
        return this::getClient;
    }

    protected void before() throws Throwable {
        final CQSecurityClient securityClient = (CQSecurityClient)this.creatorSupplier.get().adaptTo(CQSecurityClient.class);
        final Group[] assignedGroups = (Group[])Arrays.stream(this.groups).map(this.getGroupFunction(securityClient)).toArray(Group[]::new);
        class CreateUserPolling
        extends Polling {
            String username;
            String password;
            User user;

            CreateUserPolling() {
            }

            public Boolean call() throws Exception {
                this.username = TemporaryUser.this.generateName();
                this.password = TemporaryUser.this.generatePassword();
                ((List)TemporaryUser.this.usersToDelete.get()).add(this.username);
                this.user = securityClient.createUser(this.username, this.password, assignedGroups, new int[0]);
                return true;
            }
        }
        CreateUserPolling p = new CreateUserPolling();
        try {
            p.poll(TimeUnit.SECONDS.toMillis(20L), TimeUnit.SECONDS.toMillis(1L));
        }
        catch (TimeoutException e) {
            LOG.error("Timeout of 20s reached while trying to create user. List of exceptions: " + p.getExceptions(), (Throwable)e);
            this.deleteUsers();
            throw e;
        }
        LOG.info("Created user {} at {}", (Object)p.user.getId(), (Object)p.user.getHomePath());
        this.userClient.set(new CQClient(securityClient.getUrl(), p.username, p.password));
    }

    protected void after() {
        this.deleteUsers();
    }

    protected String generateName() {
        return "testuser-" + UUID.randomUUID();
    }

    protected String generatePassword() {
        return new Random().ints(97, 123).limit(30L).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    protected void deleteUsers() {
        CQSecurityClient securityClient;
        try {
            securityClient = (CQSecurityClient)this.creatorSupplier.get().adaptTo(CQSecurityClient.class);
        }
        catch (ClientException e) {
            LOG.warn("Unable to delete user", (Throwable)e);
            return;
        }
        for (String username : this.usersToDelete.get()) {
            try {
                if (!User.exists(securityClient, username)) continue;
                User userToDelete = new User(securityClient, username);
                new Polling(() -> {
                    securityClient.deleteAuthorizables(new Authorizable[]{userToDelete}, new int[0]);
                    return true;
                }).poll(TimeUnit.SECONDS.toMillis(10L), TimeUnit.SECONDS.toMillis(1L));
                LOG.info("Deleted user {}", (Object)username);
            }
            catch (Exception e) {
                LOG.warn("Failed to delete user {}, but error is ignored", (Object)username);
            }
        }
    }

    private Function<String, Group> getGroupFunction(SecurityClient client) {
        return groupName -> {
            try {
                return new Group(client, (String)groupName);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to load group " + groupName, e);
            }
        };
    }
}

