/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dct.exception;

import com.adobe.dct.exception.LogLevels;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageLogger {
    private static final Logger log = LoggerFactory.getLogger(MessageLogger.class);
    private static final String BUNDLE_NAME = "com.adobe.dct.exception.exceptions";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("com.adobe.dct.exception.exceptions");

    private MessageLogger() {
    }

    public static String getString(String key) {
        try {
            return RESOURCE_BUNDLE.getString(key);
        }
        catch (MissingResourceException e) {
            log.trace("Invalid String format for Logging Message", (Throwable)e);
            return '!' + key + '!';
        }
    }

    public static String getString(String key, String[] args) {
        String str = MessageLogger.getString(key);
        if (args != null) {
            int len = args.length;
            for (int i = 0; i < len; ++i) {
                String temp = args[i];
                if (temp != null) {
                    temp = temp.replaceAll("\\$", "\\\\\\$");
                }
                str = str.replaceAll("\\{" + i + "\\}", temp);
            }
        }
        return str;
    }

    public static void logMessage(Class className, LogLevels severity, String key, String[] args) {
        Logger logger = LoggerFactory.getLogger((Class)className);
        MessageLogger.logMessage(logger, MessageLogger.getString(key, args), severity);
    }

    public static void logMessage(Class className, LogLevels severity, String key) {
        Logger logger = LoggerFactory.getLogger((Class)className);
        MessageLogger.logMessage(logger, MessageLogger.getString(key), severity);
    }

    public static void logError(Class className, String key, Throwable cause) {
        Logger logger = LoggerFactory.getLogger((Class)className);
        logger.error(MessageLogger.getString(key), cause);
    }

    public static void logTrace(Class className, String message, Throwable cause) {
        Logger logger = LoggerFactory.getLogger((Class)className);
        logger.trace(message, cause);
    }

    public static boolean isTraceEnabled(Class className) {
        Logger logger = LoggerFactory.getLogger((Class)className);
        return logger.isTraceEnabled();
    }

    public static void logDebug(Class className, String message, Throwable cause) {
        Logger logger = LoggerFactory.getLogger((Class)className);
        logger.debug(message, cause);
    }

    public static void logError(Class className, String key, String[] args, Throwable cause) {
        Logger logger = LoggerFactory.getLogger((Class)className);
        logger.error(MessageLogger.getString(key, args), cause);
    }

    private static void logMessage(Logger logger, String logString, LogLevels severity) {
        switch (severity) {
            case LOG_FATAL: 
            case LOG_ERROR: {
                logger.error("[" + logString + "]");
                break;
            }
            case LOG_WARN: {
                logger.warn("[" + logString + "]");
                break;
            }
            case LOG_INFO: {
                logger.info("[" + logString + "]");
                break;
            }
            case LOG_TRACE: {
                logger.trace(logString);
                break;
            }
            default: {
                logger.debug("[" + logString + "]");
            }
        }
    }
}

