/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.promise;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.osgi.annotation.versioning.ConsumerType;
import org.osgi.util.promise.Deferred;
import org.osgi.util.promise.DeferredPromiseImpl;
import org.osgi.util.promise.FailedPromiseImpl;
import org.osgi.util.promise.FailedPromisesException;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.PromiseImpl;
import org.osgi.util.promise.ResolvedPromiseImpl;

@ConsumerType
public class PromiseFactory {
    static final PromiseFactory defaultFactory = new PromiseFactory(null, null);
    private final Executor callbackExecutor;
    private final ScheduledExecutorService scheduledExecutor;

    public PromiseFactory(Executor callbackExecutor) {
        this(callbackExecutor, null);
    }

    public PromiseFactory(Executor callbackExecutor, ScheduledExecutorService scheduledExecutor) {
        this.callbackExecutor = callbackExecutor;
        this.scheduledExecutor = scheduledExecutor;
    }

    public Executor executor() {
        if (this.callbackExecutor == null) {
            return DefaultExecutors.callbackExecutor();
        }
        return this.callbackExecutor;
    }

    public ScheduledExecutorService scheduledExecutor() {
        if (this.scheduledExecutor == null) {
            return DefaultExecutors.scheduledExecutor();
        }
        return this.scheduledExecutor;
    }

    public <T> Deferred<T> deferred() {
        return new Deferred(this);
    }

    public <T> Promise<T> resolved(T value) {
        return new ResolvedPromiseImpl<T>(value, this);
    }

    public <T> Promise<T> failed(Throwable failure) {
        return new FailedPromiseImpl(failure, this);
    }

    public <T> Promise<T> submit(Callable<? extends T> task) {
        DeferredPromiseImpl promise;
        DeferredPromiseImpl deferredPromiseImpl = promise = new DeferredPromiseImpl(this);
        deferredPromiseImpl.getClass();
        DeferredPromiseImpl.Submit submit = new DeferredPromiseImpl.Submit(deferredPromiseImpl, task);
        try {
            this.executor().execute(submit);
        }
        catch (Exception t) {
            promise.tryResolve(null, t);
        }
        return promise.orDone();
    }

    public <T, S extends T> Promise<List<T>> all(Collection<Promise<S>> promises) {
        if (promises.isEmpty()) {
            ArrayList value = new ArrayList();
            return this.resolved(value);
        }
        ArrayList<Promise<S>> list = new ArrayList<Promise<S>>(promises);
        DeferredPromiseImpl chained = new DeferredPromiseImpl(this);
        All all = new All(chained, list);
        for (Promise promise : list) {
            PromiseImpl.chain(promise, all);
        }
        return chained.orDone();
    }

    public static Executor inlineExecutor() {
        return new InlineExecutor();
    }

    private static final class DefaultExecutors
    implements ThreadFactory,
    RejectedExecutionHandler,
    Runnable {
        private static final DefaultExecutors callbacks = new DefaultExecutors();
        private static final ScheduledExecutor scheduledExecutor = new ScheduledExecutor(2, callbacks);
        private static final ThreadPoolExecutor callbackExecutor = new ThreadPoolExecutor(0, 64, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), callbacks, callbacks);
        private final AtomicBoolean shutdownHookInstalled = new AtomicBoolean();
        private final ThreadFactory delegateThreadFactory = Executors.defaultThreadFactory();

        static Executor callbackExecutor() {
            return callbackExecutor;
        }

        static ScheduledExecutorService scheduledExecutor() {
            return scheduledExecutor;
        }

        private DefaultExecutors() {
        }

        @Override
        public Thread newThread(Runnable r) {
            if (this.shutdownHookInstalled.compareAndSet(false, true)) {
                Thread shutdownThread = this.delegateThreadFactory.newThread(this);
                shutdownThread.setName("ExecutorShutdownHook," + shutdownThread.getName());
                try {
                    Runtime.getRuntime().addShutdownHook(shutdownThread);
                }
                catch (IllegalStateException e) {
                    callbackExecutor.shutdown();
                    scheduledExecutor.shutdown();
                }
            }
            Thread t = this.delegateThreadFactory.newThread(r);
            t.setName("PromiseFactory," + t.getName());
            t.setDaemon(true);
            return t;
        }

        @Override
        public void rejectedExecution(Runnable callback, ThreadPoolExecutor executor) {
            try {
                callback.run();
            }
            catch (Throwable t) {
                PromiseImpl.uncaughtException(t);
            }
        }

        @Override
        public void run() {
            callbackExecutor.setMaximumPoolSize(Math.max(1, callbackExecutor.getPoolSize()));
            scheduledExecutor.shutdown();
            BlockingQueue<Runnable> queue = scheduledExecutor.getQueue();
            if (!queue.isEmpty()) {
                for (Object r : queue.toArray()) {
                    RunnableScheduledFuture future;
                    if (!(r instanceof RunnableScheduledFuture) || (future = (RunnableScheduledFuture)r).getDelay(TimeUnit.NANOSECONDS) <= 0L || !queue.remove(future)) continue;
                    future.run();
                    scheduledExecutor.afterExecute(future, null);
                }
                scheduledExecutor.shutdown();
            }
            try {
                scheduledExecutor.awaitTermination(20L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            callbackExecutor.shutdown();
            try {
                callbackExecutor.awaitTermination(20L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        private static final class ScheduledExecutor
        extends ScheduledThreadPoolExecutor {
            ScheduledExecutor(int corePoolSize, ThreadFactory threadFactory) {
                super(corePoolSize, threadFactory);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void afterExecute(Runnable r, Throwable t) {
                super.afterExecute(r, t);
                if (t == null && r instanceof Future) {
                    boolean interrupted = Thread.interrupted();
                    try {
                        ((Future)((Object)r)).get();
                    }
                    catch (CancellationException cancellationException) {
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                    catch (ExecutionException e) {
                        t = e.getCause();
                    }
                    finally {
                        if (interrupted) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
                if (t != null) {
                    PromiseImpl.uncaughtException(t);
                }
            }
        }
    }

    private static final class InlineExecutor
    implements Executor {
        InlineExecutor() {
        }

        @Override
        public void execute(Runnable callback) {
            callback.run();
        }
    }

    private static final class All<T, S extends T>
    implements Runnable {
        private final DeferredPromiseImpl<List<T>> chained;
        private final List<Promise<S>> promises;
        private final AtomicInteger promiseCount;

        All(DeferredPromiseImpl<List<T>> chained, List<Promise<S>> promises) {
            this.chained = Objects.requireNonNull(chained);
            this.promises = Objects.requireNonNull(promises);
            this.promiseCount = new AtomicInteger(promises.size());
        }

        @Override
        public void run() {
            if (this.promiseCount.decrementAndGet() != 0) {
                return;
            }
            ArrayList value = new ArrayList(this.promises.size());
            ArrayList failed = new ArrayList(this.promises.size());
            Throwable cause = null;
            for (Promise<S> p : this.promises) {
                PromiseImpl.Result<S> result = PromiseImpl.collect(p);
                if (result.fail != null) {
                    failed.add(p);
                    if (cause != null) continue;
                    cause = result.fail;
                    continue;
                }
                value.add(result.value);
            }
            if (failed.isEmpty()) {
                this.chained.tryResolve(value, null);
            } else {
                this.chained.tryResolve(null, new FailedPromisesException(failed, cause));
            }
        }
    }
}

