/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.converter;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class Util {
    private static final Map<Class<?>, Class<?>> boxedClasses;

    private Util() {
    }

    static Type primitiveToBoxed(Type type) {
        if (type instanceof Class) {
            return Util.primitiveToBoxed((Class)type);
        }
        return null;
    }

    static Type baseType(Type type) {
        if (type instanceof Class) {
            return Util.primitiveToBoxed((Class)type);
        }
        if (type instanceof ParameterizedType) {
            return type;
        }
        return null;
    }

    static Class<?> primitiveToBoxed(Class<?> cls) {
        Class<?> boxed = boxedClasses.get(cls);
        if (boxed != null) {
            return boxed;
        }
        return cls;
    }

    static Map<String, Method> getBeanKeys(Class<?> beanClass) {
        LinkedHashMap<String, Method> keys = new LinkedHashMap<String, Method>();
        for (Method md : beanClass.getDeclaredMethods()) {
            String key = Util.getBeanKey(md);
            if (key == null || keys.containsKey(key)) continue;
            keys.put(key, md);
        }
        return keys;
    }

    static String getBeanKey(Method md) {
        if (Modifier.isStatic(md.getModifiers())) {
            return null;
        }
        if (!Modifier.isPublic(md.getModifiers())) {
            return null;
        }
        return Util.getBeanAccessorPropertyName(md);
    }

    private static String getBeanAccessorPropertyName(Method md) {
        int prefix;
        if (md.getReturnType().equals(Void.class)) {
            return null;
        }
        if (md.getParameterTypes().length > 0) {
            return null;
        }
        if (Object.class.equals(md.getDeclaringClass())) {
            return null;
        }
        String mn = md.getName();
        if (mn.startsWith("get")) {
            prefix = 3;
        } else if (mn.startsWith("is")) {
            prefix = 2;
        } else {
            return null;
        }
        if (mn.length() <= prefix) {
            return null;
        }
        String propStr = mn.substring(prefix);
        StringBuilder propName = new StringBuilder(propStr.length());
        char firstChar = propStr.charAt(0);
        if (!Character.isUpperCase(firstChar)) {
            return null;
        }
        propName.append(Character.toLowerCase(firstChar));
        if (propStr.length() > 1) {
            propName.append(propStr.substring(1));
        }
        return Util.unMangleName(Util.getPrefix(md.getDeclaringClass()), propName.toString());
    }

    static Map<String, Field> getDTOKeys(Class<?> dto) {
        LinkedHashMap<String, Field> keys = new LinkedHashMap<String, Field>();
        for (Field f : dto.getFields()) {
            String key = Util.getDTOKey(f);
            if (key == null || keys.containsKey(key)) continue;
            keys.put(key, f);
        }
        return keys;
    }

    static String getDTOKey(Field f) {
        if (Modifier.isStatic(f.getModifiers())) {
            return null;
        }
        if (!Modifier.isPublic(f.getModifiers())) {
            return null;
        }
        return Util.unMangleName(Util.getPrefix(f.getDeclaringClass()), f.getName());
    }

    static Map<String, Set<Method>> getInterfaceKeys(Class<?> intf, Object object) {
        LinkedHashMap<String, Set<Method>> keys = new LinkedHashMap<String, Set<Method>>();
        String seank = Util.getSingleElementAnnotationKey(intf, object);
        for (Method md : intf.getMethods()) {
            String name = Util.getInterfacePropertyName(md, seank, object);
            if (name == null) continue;
            LinkedHashSet<Method> set = (LinkedHashSet<Method>)keys.get(name);
            if (set == null) {
                set = new LinkedHashSet<Method>();
                keys.put(name, set);
            }
            md.setAccessible(true);
            set.add(md);
        }
        Iterator it = keys.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            boolean zeroArgFound = false;
            for (Method md : (Set)entry.getValue()) {
                if (md.getParameterTypes().length != 0) continue;
                zeroArgFound = true;
                break;
            }
            if (zeroArgFound) continue;
            it.remove();
        }
        return keys;
    }

    static String getSingleElementAnnotationKey(Class<?> intf, Object obj) {
        Class<?> ann = Util.getAnnotationType(intf, obj);
        if (ann == null) {
            return null;
        }
        boolean valueFound = false;
        for (Method md : ann.getDeclaredMethods()) {
            if ("value".equals(md.getName())) {
                valueFound = true;
                continue;
            }
            if (md.getDefaultValue() != null) continue;
            return null;
        }
        if (!valueFound) {
            return null;
        }
        return Util.getPrefix(ann) + Util.toSingleElementAnnotationKey(ann.getSimpleName());
    }

    static Class<?> getAnnotationType(Class<?> intf, Object obj) {
        try {
            Method md = intf.getMethod("annotationType", new Class[0]);
            Object res = md.invoke(obj, new Object[0]);
            if (res instanceof Class) {
                return (Class)res;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static String toSingleElementAnnotationKey(String simpleName) {
        StringBuilder sb = new StringBuilder();
        boolean capitalSeen = true;
        for (char c : simpleName.toCharArray()) {
            if (!capitalSeen) {
                if (Character.isUpperCase(c)) {
                    capitalSeen = true;
                    sb.append('.');
                }
            } else if (Character.isLowerCase(c)) {
                capitalSeen = false;
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    static String getInterfacePropertyName(Method md, String singleElementAnnotationKey, Object object) {
        if (md.getReturnType().equals(Void.class)) {
            return null;
        }
        if (md.getParameterTypes().length > 1) {
            return null;
        }
        if ("value".equals(md.getName()) && md.getParameterTypes().length == 0 && singleElementAnnotationKey != null) {
            return singleElementAnnotationKey;
        }
        if (Object.class.equals(md.getDeclaringClass()) || Annotation.class.equals(md.getDeclaringClass())) {
            return null;
        }
        if ("annotationType".equals(md.getName()) && md.getParameterTypes().length == 0) {
            try {
                Object cls = md.invoke(object, new Object[0]);
                if (cls instanceof Class && ((Class)cls).isAnnotation()) {
                    return null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (md.getDeclaringClass().getSimpleName().startsWith("$Proxy") && (Util.isInheritedMethodInProxy(md, Object.class) || Util.isInheritedMethodInProxy(md, Annotation.class))) {
            return null;
        }
        return Util.unMangleName(Util.getPrefix(md.getDeclaringClass()), md.getName());
    }

    private static boolean isInheritedMethodInProxy(Method md, Class<?> cls) {
        for (Method om : cls.getMethods()) {
            if (!om.getName().equals(md.getName()) || !Arrays.equals(om.getParameterTypes(), md.getParameterTypes())) continue;
            return true;
        }
        return false;
    }

    static Object getInterfaceProperty(Object obj, Method md) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (Modifier.isStatic(md.getModifiers())) {
            return null;
        }
        if (md.getParameterTypes().length > 0) {
            return null;
        }
        return md.invoke(obj, new Object[0]);
    }

    static String getPrefix(Class<?> cls) {
        try {
            Field prefixField = cls.getDeclaredField("PREFIX_");
            if (prefixField.getType().equals(String.class) && (prefixField.getModifiers() & 0x19) > 0) {
                return (String)prefixField.get(null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!cls.isInterface()) {
            for (Class<?> intf : cls.getInterfaces()) {
                String prefix = Util.getPrefix(intf);
                if (prefix.length() <= 0) continue;
                return prefix;
            }
        }
        return "";
    }

    static String mangleName(String prefix, String key, List<String> names) {
        if (!key.startsWith(prefix)) {
            return null;
        }
        key = key.substring(prefix.length());
        for (String name : names) {
            if (!key.equals(Util.unMangleName(name))) continue;
            return name;
        }
        String res = key.replace("_", "__");
        res = res.replace("$", "$$");
        res = res.replace("-", "$_$");
        res = res.replaceAll("[.]([._])", "_\\$$1");
        res = res.replace('.', '_');
        return res;
    }

    static String unMangleName(String prefix, String key) {
        return prefix + Util.unMangleName(key);
    }

    static String unMangleName(String id) {
        char[] array = id.toCharArray();
        int out = 0;
        boolean changed = false;
        for (int i = 0; i < array.length; ++i) {
            if (Util.match("$$", array, i) || Util.match("__", array, i)) {
                array[out++] = array[i++];
                changed = true;
                continue;
            }
            if (Util.match("$_$", array, i)) {
                array[out++] = 45;
                i += 2;
                continue;
            }
            char c = array[i];
            if (c == '_') {
                array[out++] = 46;
                changed = true;
                continue;
            }
            if (c == '$') {
                changed = true;
                continue;
            }
            array[out++] = c;
        }
        if (id.length() != out || changed) {
            return new String(array, 0, out);
        }
        return id;
    }

    private static boolean match(String pattern, char[] array, int i) {
        int j = 0;
        while (j < pattern.length()) {
            if (i >= array.length) {
                return false;
            }
            if (pattern.charAt(j) != array[i]) {
                return false;
            }
            ++j;
            ++i;
        }
        return true;
    }

    static {
        HashMap<Class<Object>, Class<Short>> m = new HashMap<Class<Object>, Class<Short>>();
        m.put(Integer.TYPE, Integer.class);
        m.put(Long.TYPE, Long.class);
        m.put(Double.TYPE, Double.class);
        m.put(Float.TYPE, Float.class);
        m.put(Boolean.TYPE, Boolean.class);
        m.put(Character.TYPE, Character.class);
        m.put(Byte.TYPE, Byte.class);
        m.put(Void.TYPE, Void.class);
        m.put(Short.TYPE, Short.class);
        boxedClasses = Collections.unmodifiableMap(m);
    }
}

