/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.poi.hpsf.ClassID;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.Ole10Native;
import org.apache.poi.poifs.filesystem.Ole10NativeException;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.detect.Detector;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.PasswordProvider;
import org.apache.tika.parser.microsoft.OfficeParser;
import org.apache.tika.parser.microsoft.OfficeParserConfig;
import org.apache.tika.parser.pkg.ZipContainerDetector;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.SAXException;

abstract class AbstractPOIFSExtractor {
    private final EmbeddedDocumentUtil embeddedDocumentUtil;
    private PasswordProvider passwordProvider;
    protected final Metadata parentMetadata;
    protected final OfficeParserConfig officeParserConfig;
    protected final ParseContext context;

    protected AbstractPOIFSExtractor(ParseContext context) {
        this(context, null);
    }

    protected AbstractPOIFSExtractor(ParseContext context, Metadata parentMetadata) {
        this.embeddedDocumentUtil = new EmbeddedDocumentUtil(context);
        this.passwordProvider = context.get(PasswordProvider.class);
        this.officeParserConfig = context.get(OfficeParserConfig.class, new OfficeParserConfig());
        this.parentMetadata = parentMetadata;
        this.context = context;
    }

    protected TikaConfig getTikaConfig() {
        return this.embeddedDocumentUtil.getTikaConfig();
    }

    protected Detector getDetector() {
        return this.embeddedDocumentUtil.getDetector();
    }

    protected MimeTypes getMimeTypes() {
        return this.embeddedDocumentUtil.getMimeTypes();
    }

    protected String getPassword() {
        if (this.passwordProvider != null) {
            return this.passwordProvider.getPassword(this.parentMetadata);
        }
        return null;
    }

    protected void handleEmbeddedResource(TikaInputStream resource, String filename, String relationshipID, String mediaType, XHTMLContentHandler xhtml, boolean outputHtml) throws IOException, SAXException, TikaException {
        this.handleEmbeddedResource(resource, filename, relationshipID, null, mediaType, xhtml, outputHtml);
    }

    protected void handleEmbeddedResource(TikaInputStream resource, String filename, String relationshipID, ClassID storageClassID, String mediaType, XHTMLContentHandler xhtml, boolean outputHtml) throws IOException, SAXException, TikaException {
        this.handleEmbeddedResource(resource, new Metadata(), filename, relationshipID, storageClassID, mediaType, xhtml, outputHtml);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleEmbeddedResource(TikaInputStream resource, Metadata embeddedMetadata, String filename, String relationshipID, ClassID storageClassID, String mediaType, XHTMLContentHandler xhtml, boolean outputHtml) throws IOException, SAXException, TikaException {
        try {
            if (filename != null) {
                embeddedMetadata.set("tika.mime.file", filename);
                embeddedMetadata.set("resourceName", filename);
            }
            if (relationshipID != null) {
                embeddedMetadata.set("embeddedRelationshipId", relationshipID);
            }
            if (storageClassID != null) {
                embeddedMetadata.set("embeddedStorageClassId", storageClassID.toString());
            }
            if (mediaType != null) {
                embeddedMetadata.set("Content-Type", mediaType);
            }
            if (this.embeddedDocumentUtil.shouldParseEmbedded(embeddedMetadata)) {
                this.embeddedDocumentUtil.parseEmbedded(resource, xhtml, embeddedMetadata, outputHtml);
            }
        }
        finally {
            resource.close();
        }
    }

    protected void handleEmbeddedOfficeDoc(DirectoryEntry dir, XHTMLContentHandler xhtml) throws IOException, SAXException, TikaException {
        this.handleEmbeddedOfficeDoc(dir, null, xhtml);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleEmbeddedOfficeDoc(DirectoryEntry dir, String resourceName, XHTMLContentHandler xhtml) throws IOException, SAXException, TikaException {
        if (dir.hasEntry("Package")) {
            Entry ooxml = dir.getEntry("Package");
            try (TikaInputStream stream = TikaInputStream.get(new DocumentInputStream((DocumentEntry)ooxml));){
                ZipContainerDetector detector = new ZipContainerDetector();
                MediaType type = null;
                try {
                    type = detector.detect(stream, new Metadata());
                }
                catch (Exception e) {
                    EmbeddedDocumentUtil.recordEmbeddedStreamException(e, this.parentMetadata);
                    if (stream != null) {
                        if (var6_8 != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable) {
                                var6_8.addSuppressed(throwable);
                            }
                        } else {
                            stream.close();
                        }
                    }
                    return;
                }
                this.handleEmbeddedResource(stream, null, dir.getName(), dir.getStorageClsid(), type.toString(), xhtml, true);
                return;
            }
        }
        Metadata metadata = new Metadata();
        metadata.set("embeddedRelationshipId", dir.getName());
        if (dir.getStorageClsid() != null) {
            metadata.set("embeddedStorageClassId", dir.getStorageClsid().toString());
        }
        OfficeParser.POIFSDocumentType type = OfficeParser.POIFSDocumentType.detectType(dir);
        String rName = resourceName == null ? dir.getName() : resourceName;
        try (TikaInputStream embedded = null;){
            if (type == OfficeParser.POIFSDocumentType.OLE10_NATIVE) {
                try {
                    Ole10Native ole = Ole10Native.createFromEmbeddedOleObject((DirectoryNode)dir);
                    if (ole.getLabel() != null) {
                        metadata.set("resourceName", rName + '/' + ole.getLabel());
                    }
                    if (ole.getCommand() != null) {
                        metadata.add(TikaCoreProperties.ORIGINAL_RESOURCE_NAME, ole.getCommand());
                    }
                    if (ole.getFileName() != null) {
                        metadata.add(TikaCoreProperties.ORIGINAL_RESOURCE_NAME, ole.getFileName());
                    }
                    byte[] data = ole.getDataBuffer();
                    embedded = TikaInputStream.get(data);
                }
                catch (Ole10NativeException ole) {
                }
                catch (Exception e) {
                    EmbeddedDocumentUtil.recordEmbeddedStreamException(e, this.parentMetadata);
                    if (embedded != null) {
                        embedded.close();
                    }
                    return;
                }
            } else {
                if (type == OfficeParser.POIFSDocumentType.COMP_OBJ) {
                    try {
                        DocumentEntry contentsEntry;
                        try {
                            contentsEntry = (DocumentEntry)dir.getEntry("CONTENTS");
                        }
                        catch (FileNotFoundException ioe) {
                            contentsEntry = (DocumentEntry)dir.getEntry("Contents");
                        }
                        DocumentInputStream inp = new DocumentInputStream(contentsEntry);
                        byte[] contents = new byte[contentsEntry.getSize()];
                        inp.readFully(contents);
                        embedded = TikaInputStream.get(contents);
                        MediaType mediaType = this.getDetector().detect(embedded, new Metadata());
                        String extension = type.getExtension();
                        try {
                            MimeType mimeType = this.getMimeTypes().forName(mediaType.toString());
                            extension = mimeType.getExtension();
                        }
                        catch (MimeTypeException mimeTypeException) {
                            // empty catch block
                        }
                        metadata.set("Content-Type", mediaType.getType().toString());
                        metadata.set("resourceName", rName + extension);
                    }
                    catch (Exception e) {
                        EmbeddedDocumentUtil.recordEmbeddedStreamException(e, this.parentMetadata);
                        if (embedded != null) {
                            embedded.close();
                        }
                        return;
                    }
                }
                metadata.set("Content-Type", type.getType().toString());
                metadata.set("resourceName", rName + '.' + type.getExtension());
            }
            if (this.embeddedDocumentUtil.shouldParseEmbedded(metadata)) {
                if (embedded == null) {
                    embedded = TikaInputStream.get(new byte[0]);
                    embedded.setOpenContainer(dir);
                }
                this.embeddedDocumentUtil.parseEmbedded(embedded, xhtml, metadata, true);
            }
        }
    }
}

