/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.render;

import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.sling.scripting.sightly.Record;
import org.apache.sling.scripting.sightly.render.ObjectModel;
import org.apache.sling.scripting.sightly.render.RuntimeObjectModel;

public abstract class AbstractRuntimeObjectModel
implements RuntimeObjectModel {
    @Override
    public boolean isPrimitive(Object obj) {
        return ObjectModel.isPrimitive(obj);
    }

    @Override
    public boolean isDate(Object target) {
        return target instanceof Date || target instanceof Calendar;
    }

    @Override
    public boolean isNumber(Object target) {
        if (target == null) {
            return false;
        }
        if (target instanceof Number) {
            return true;
        }
        String value = this.toString(target);
        return NumberUtils.isCreatable(value);
    }

    @Override
    public boolean isCollection(Object target) {
        return target instanceof Collection || target instanceof Object[] || target instanceof Iterable || target instanceof Iterator;
    }

    @Override
    public Object resolveProperty(Object target, Object property) {
        if (target == null || property == null) {
            return null;
        }
        Object resolved = null;
        if (property instanceof Number) {
            resolved = ObjectModel.getIndex(target, ((Number)property).intValue());
        }
        if (resolved == null) {
            resolved = this.getProperty(target, property);
        }
        return resolved;
    }

    @Override
    public boolean toBoolean(Object object) {
        return ObjectModel.toBoolean(object);
    }

    @Override
    public Number toNumber(Object object) {
        return ObjectModel.toNumber(object);
    }

    @Override
    public Date toDate(Object object) {
        if (object instanceof Date) {
            return (Date)object;
        }
        if (object instanceof Calendar) {
            return ((Calendar)object).getTime();
        }
        return null;
    }

    @Override
    public String toString(Object target) {
        return ObjectModel.toString(target);
    }

    @Override
    public Collection<Object> toCollection(Object object) {
        if (object instanceof Record) {
            return ((Record)object).getPropertyNames();
        }
        return ObjectModel.toCollection(object);
    }

    @Override
    public Map toMap(Object object) {
        if (object instanceof Map) {
            return (Map)object;
        }
        if (object instanceof Record) {
            HashMap map = new HashMap();
            Record record = (Record)object;
            Set<String> properties = record.getPropertyNames();
            for (String property : properties) {
                map.put(property, record.getProperty(property));
            }
            return map;
        }
        return Collections.emptyMap();
    }

    protected Object getProperty(Object target, Object propertyObj) {
        if (target == null || propertyObj == null) {
            return null;
        }
        String property = ObjectModel.toString(propertyObj);
        Object result = null;
        if (target instanceof Record) {
            result = ((Record)target).getProperty(property);
        }
        if (result == null) {
            result = ObjectModel.resolveProperty(target, propertyObj);
        }
        return result;
    }
}

