/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.jsp.taglib;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.servlet.jsp.PageContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.caconfig.resource.ConfigurationResourceResolver;
import org.apache.sling.scripting.jsp.taglib.internal.XSSSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlingFunctions {
    private static final Logger log = LoggerFactory.getLogger(SlingFunctions.class);

    public static Object adaptTo(Adaptable adaptable, String adapter) throws ClassNotFoundException {
        log.trace("adaptTo");
        Object adapted = null;
        if (adaptable != null) {
            log.debug("Adapting {} to class {}", (Object)adaptable, (Object)adapter);
            try {
                Class<?> adapterClass = SlingFunctions.loadClass(adapter);
                adapted = adaptable.adaptTo(adapterClass);
            }
            catch (ClassNotFoundException e) {
                log.error("Could not load class " + adapter, e);
            }
        } else {
            log.debug("Null adaptable specified");
        }
        return adapted;
    }

    public static String encode(String value, String mode) {
        return XSSSupport.encode((String)value, (XSSSupport.EncodingMode)XSSSupport.getEncodingMode((String)mode));
    }

    public static Iterator<Resource> findResources(ResourceResolver resourceResolver, String query, String language) {
        log.trace("findResources");
        Iterator<Resource> resources = null;
        if (resourceResolver != null) {
            log.debug("Finding resources with query {} of type {}", (Object)query, (Object)language);
            resources = resourceResolver.findResources(query, language);
        } else {
            log.warn("Null resolver specified");
        }
        return resources;
    }

    public static final Resource getAbsoluteParent(Resource current, String level) {
        log.trace("getAbsoluteParent");
        Resource parent = null;
        if (level != null) {
            String[] segments = current.getPath().split("\\/");
            int end = Integer.parseInt(level, 10);
            String parentPath = "/" + StringUtils.join((Object[])Arrays.copyOfRange(segments, 1, end + 1), "/");
            log.debug("Retrieving {} parent resource at path {}", (Object)level, (Object)parentPath);
            parent = current.getResourceResolver().getResource(parentPath);
        } else {
            log.debug("Retrieving parent resource");
            parent = current.getParent();
        }
        return parent;
    }

    public static final Resource getCAConfigResource(Resource resource, String bucket, String name) {
        log.trace("getCAConfigResource");
        ConfigurationResourceResolver caResourceResolver = resource.getResourceResolver().adaptTo(ConfigurationResourceResolver.class);
        return caResourceResolver.getResource(resource, bucket, name);
    }

    public static final Iterator<Resource> getCAConfigResources(Resource resource, String bucket, String name) {
        log.trace("getCAConfigResource");
        ConfigurationResourceResolver caResourceResolver = resource.getResourceResolver().adaptTo(ConfigurationResourceResolver.class);
        return caResourceResolver.getResourceCollection(resource, bucket, name).iterator();
    }

    public static final Iterator<Resource> getParents(Resource current, String startDepth) {
        Resource parent;
        List<Resource> parents = new ArrayList<Resource>();
        while ((parent = current.getParent()) != null) {
            parents.add(parent);
            current = parent;
        }
        Collections.reverse(parents);
        int depth = Integer.parseInt(startDepth, 10);
        if (depth <= parents.size()) {
            parents = parents.subList(depth, parents.size());
        } else {
            parents.clear();
        }
        return parents.iterator();
    }

    public static Resource getRelativeResource(Resource base, String path) {
        log.trace("getRelativeResource");
        Resource relative = null;
        if (base != null) {
            log.debug("Getting relative resource of {} at path {}", (Object)base.getPath(), (Object)path);
            relative = base.getResourceResolver().getResource(base, path);
        } else {
            log.warn("Null base resource specified");
        }
        return relative;
    }

    public static final Resource getResource(ResourceResolver resolver, String path) {
        log.trace("getResource");
        log.debug("Getting resource at path {}", (Object)path);
        if (resolver == null) {
            throw new IllegalArgumentException("Null resource resolver");
        }
        return resolver.getResource(path);
    }

    protected static final ResourceResolver getResourceResolver(PageContext pageContext) {
        SlingBindings bindings = (SlingBindings)pageContext.getRequest().getAttribute(SlingBindings.class.getName());
        SlingScriptHelper scriptHelper = bindings.getSling();
        return scriptHelper.getRequest().getResourceResolver();
    }

    public static final <E> E getValue(ValueMap properties, String key, Object defaultOrType) {
        if (defaultOrType instanceof Class) {
            return (E)properties.get(key, (Class)defaultOrType);
        }
        return (E)properties.get(key, defaultOrType);
    }

    public static final boolean hasChildren(Resource resource) {
        return resource != null ? resource.listChildren().hasNext() : false;
    }

    public static final Iterator<Resource> listChildren(Resource resource) {
        log.trace("listChildren");
        Iterator<Resource> children = null;
        if (resource != null) {
            log.debug("Listing children at path {}", (Object)resource.getPath());
            children = resource.listChildren();
        } else {
            log.warn("Null resource specified");
        }
        return children;
    }

    private static Class<?> loadClass(String className) throws ClassNotFoundException {
        return Thread.currentThread().getContextClassLoader().loadClass(className);
    }
}

