/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.jsp.taglib;

import javax.servlet.Servlet;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.api.servlets.ServletResolver;
import org.apache.sling.scripting.jsp.util.JspSlingHttpServletResponseWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvalTagHandler
extends TagSupport {
    private static final long serialVersionUID = 7070941156517599283L;
    private static final Logger log = LoggerFactory.getLogger(EvalTagHandler.class);
    private transient Resource resource;
    private String script;
    private String resourceType;
    private boolean ignoreResourceTypeHierarchy = false;
    private boolean flush = false;

    public int doEndTag() throws JspException {
        Servlet servlet;
        log.debug("EvalTagHandler doEndTag");
        SlingBindings bindings = (SlingBindings)this.pageContext.getRequest().getAttribute(SlingBindings.class.getName());
        SlingScriptHelper scriptHelper = bindings.getSling();
        ServletResolver servletResolver = scriptHelper.getService(ServletResolver.class);
        if (!this.ignoreResourceTypeHierarchy) {
            Resource evalResource = this.resource != null ? this.resource : (this.resourceType != null ? new SyntheticResource(bindings.getRequest().getResourceResolver(), bindings.getResource().getPath(), this.resourceType) : bindings.getResource());
            servlet = servletResolver.resolveServlet(evalResource, this.script);
        } else {
            String scriptPath;
            ResourceResolver rr = bindings.getRequest().getResourceResolver();
            if (!this.script.startsWith("/")) {
                String parentPath = ResourceUtil.getParent(scriptHelper.getScript().getScriptResource().getPath());
                for (String sp : rr.getSearchPath()) {
                    if (!parentPath.startsWith(sp)) continue;
                    parentPath = parentPath.substring(sp.length());
                    break;
                }
                scriptPath = parentPath + '/' + this.script;
            } else {
                scriptPath = this.script;
            }
            servlet = servletResolver.resolveServlet(rr, scriptPath);
        }
        if (servlet == null) {
            throw new JspException("Could not find script '" + this.script + "' referenced in jsp " + scriptHelper.getScript().getScriptResource().getPath());
        }
        try {
            if (this.flush && !(this.pageContext.getOut() instanceof BodyContent)) {
                this.pageContext.getOut().flush();
            }
            JspSlingHttpServletResponseWrapper response = new JspSlingHttpServletResponseWrapper(this.pageContext);
            servlet.service(this.pageContext.getRequest(), response);
            return 6;
        }
        catch (Exception e) {
            log.error("Error while executing script " + this.script, e);
            throw new JspException("Error while executing script " + this.script, (Throwable)e);
        }
    }

    public void setPageContext(PageContext pageContext) {
        super.setPageContext(pageContext);
        this.resource = null;
        this.resourceType = null;
        this.ignoreResourceTypeHierarchy = false;
        this.script = null;
        this.flush = false;
    }

    public void setFlush(boolean flush) {
        this.flush = flush;
    }

    public void setResource(Resource rsrc) {
        this.resource = rsrc;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public void setResourceType(String rsrcType) {
        this.resourceType = rsrcType;
    }

    public void setIgnoreResourceTypeHierarchy(boolean flag) {
        this.ignoreResourceTypeHierarchy = flag;
    }
}

