/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.repoinit.parser.operations;

import org.apache.sling.repoinit.parser.operations.Operation;
import org.apache.sling.repoinit.parser.operations.OperationVisitor;

public class CreateUser
extends Operation {
    private final String username;
    private final String passwordEncoding;
    private final String password;
    private final String path;

    public CreateUser(String username, String passwordEncoding, String password) {
        this(username, passwordEncoding, password, null);
    }

    public CreateUser(String username, String passwordEncoding, String password, String path) {
        this.username = username;
        this.passwordEncoding = passwordEncoding;
        this.password = password;
        this.path = path;
    }

    @Override
    public void accept(OperationVisitor v) {
        v.visitCreateUser(this);
    }

    @Override
    protected String getParametersDescription() {
        StringBuilder sb = new StringBuilder(this.username);
        if (this.path != null) {
            sb.append(" with path ").append(this.path);
        }
        if (this.password != null) {
            if (this.passwordEncoding == null) {
                sb.append(" (with password)");
            } else {
                sb.append(" (with encoded password)");
            }
        }
        return sb.toString();
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPasswordEncoding() {
        return this.passwordEncoding;
    }

    public String getPath() {
        return this.path;
    }
}

