/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.commons.providers.spi.base;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServiceWithBackgroundCheck {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected String slingId;
    protected BackgroundCheckRunnable backgroundCheckRunnable;

    protected void cancelPreviousBackgroundCheck() {
        BackgroundCheckRunnable current = this.backgroundCheckRunnable;
        if (current != null) {
            current.cancel();
        }
    }

    protected void startBackgroundCheck(String threadName, BackgroundCheck check, Runnable callback, long timeoutMillis, long waitMillis) {
        this.cancelPreviousBackgroundCheck();
        if (check.check()) {
            if (callback != null) {
                this.logger.info("backgroundCheck: already done, backgroundCheck successful, invoking callback");
                callback.run();
            } else {
                this.logger.info("backgroundCheck: already done, backgroundCheck successful. no callback to invoke.");
            }
            return;
        }
        this.logger.info("backgroundCheck: spawning background-thread for '" + threadName + "'");
        this.backgroundCheckRunnable = new BackgroundCheckRunnable(callback, check, timeoutMillis, waitMillis, threadName);
        Thread th = new Thread(this.backgroundCheckRunnable);
        th.setName(threadName);
        th.setDaemon(true);
        th.start();
    }

    protected void triggerBackgroundCheck() {
        BackgroundCheckRunnable backgroundOp = this.backgroundCheckRunnable;
        if (backgroundOp != null) {
            backgroundOp.triggerCheck();
        }
    }

    static interface BackgroundCheck {
        public boolean check();
    }

    final class BackgroundCheckRunnable
    implements Runnable {
        private final Runnable callback;
        private final BackgroundCheck check;
        private final long timeoutMillis;
        private volatile boolean cancelled;
        private final String threadName;
        private final Object waitObj = new Object();
        private int waitCnt;
        private volatile boolean done;
        private long waitInterval;

        private BackgroundCheckRunnable(Runnable callback, BackgroundCheck check, long timeoutMillis, long waitInterval, String threadName) {
            this.callback = callback;
            this.check = check;
            this.timeoutMillis = timeoutMillis;
            if (waitInterval <= 0L) {
                throw new IllegalArgumentException("waitInterval must be greater than 0: " + waitInterval);
            }
            this.waitInterval = waitInterval;
            this.threadName = threadName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isDone() {
            Object object = this.waitObj;
            synchronized (object) {
                return this.done;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AbstractServiceWithBackgroundCheck.this.logger.debug("backgroundCheck.run: start");
            long start = System.currentTimeMillis();
            try {
                while (!this.cancelled()) {
                    if (this.check.check()) {
                        if (this.callback != null) {
                            this.callback.run();
                        }
                        return;
                    }
                    if (this.timeoutMillis != -1L && System.currentTimeMillis() > start + this.timeoutMillis) {
                        if (this.callback == null) {
                            AbstractServiceWithBackgroundCheck.this.logger.info("backgroundCheck.run: timeout hit (no callback to invoke)");
                        } else {
                            AbstractServiceWithBackgroundCheck.this.logger.info("backgroundCheck.run: timeout hit, invoking callback.");
                            this.callback.run();
                        }
                        return;
                    }
                    AbstractServiceWithBackgroundCheck.this.logger.trace("backgroundCheck.run: waiting another sec.");
                    Object object = this.waitObj;
                    synchronized (object) {
                        ++this.waitCnt;
                        try {
                            this.waitObj.notify();
                            this.waitObj.wait(this.waitInterval);
                        }
                        catch (InterruptedException e) {
                            AbstractServiceWithBackgroundCheck.this.logger.debug("backgroundCheck.run: got interrupted");
                        }
                    }
                }
                AbstractServiceWithBackgroundCheck.this.logger.debug("backgroundCheck.run: this run got cancelled. {}", (Object)this.check);
            }
            catch (RuntimeException re) {
                AbstractServiceWithBackgroundCheck.this.logger.error("backgroundCheck.run: RuntimeException: " + re, re);
                if (this.callback != null) {
                    AbstractServiceWithBackgroundCheck.this.logger.info("backgroundCheck.run: RuntimeException -> invoking callback");
                    this.callback.run();
                }
                throw re;
            }
            catch (Error er) {
                AbstractServiceWithBackgroundCheck.this.logger.error("backgroundCheck.run: Error: " + er, er);
                AbstractServiceWithBackgroundCheck.this.logger.info("backgroundCheck.run: NOT invoking callback");
                throw er;
            }
            finally {
                AbstractServiceWithBackgroundCheck.this.logger.debug("backgroundCheck.run: end");
                Object object = this.waitObj;
                synchronized (object) {
                    this.done = true;
                    this.waitObj.notify();
                }
            }
        }

        boolean cancelled() {
            return this.cancelled;
        }

        void cancel() {
            if (!this.done) {
                AbstractServiceWithBackgroundCheck.this.logger.info("cancel: " + this.threadName);
            }
            this.cancelled = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void triggerCheck() {
            Object object = this.waitObj;
            synchronized (object) {
                int waitCntAtStart = this.waitCnt;
                this.waitObj.notify();
                while (!this.done && this.waitCnt <= waitCntAtStart) {
                    try {
                        this.waitObj.wait();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException("got interrupted");
                    }
                }
            }
        }
    }
}

