/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.commons.providers.base;

import java.util.LinkedList;
import java.util.List;
import org.apache.sling.discovery.TopologyEvent;
import org.apache.sling.discovery.TopologyEventListener;
import org.apache.sling.discovery.commons.providers.base.AsyncEvent;
import org.apache.sling.discovery.commons.providers.base.AsyncTopologyEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AsyncEventSender
implements Runnable {
    static final Logger logger = LoggerFactory.getLogger(AsyncEventSender.class);
    private boolean stopped = false;
    private final List<AsyncEvent> eventQ = new LinkedList<AsyncEvent>();
    private boolean isSending = false;

    AsyncEventSender() {
    }

    void enqueue(TopologyEventListener listener, TopologyEvent event) {
        AsyncTopologyEvent asyncEvent = new AsyncTopologyEvent(listener, event);
        this.enqueue(asyncEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueue(AsyncEvent asyncEvent) {
        List<AsyncEvent> list = this.eventQ;
        synchronized (list) {
            this.eventQ.add(asyncEvent);
            if (logger.isDebugEnabled()) {
                logger.debug("enqueue: enqueued event {} for async sending (Q size: {})", (Object)asyncEvent, (Object)this.eventQ.size());
            }
            this.eventQ.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushThenStop() {
        List<AsyncEvent> list = this.eventQ;
        synchronized (list) {
            logger.info("AsyncEventSender.flushThenStop: flushing (size: {}) & stopping...", (Object)this.eventQ.size());
            this.stopped = true;
            this.eventQ.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        AsyncEventSender.logger.info("AsyncEventSender.run: started.");
        while (true) {
            try {
                while (true) {
                    var2_3 = this.eventQ;
                    // MONITORENTER : var2_3
                    this.isSending = false;
                    while (!this.stopped && this.eventQ.isEmpty()) {
                        try {
                            this.eventQ.wait();
                        }
                        catch (InterruptedException e) {
                            AsyncEventSender.logger.debug("AsyncEventSender.run: interrupted while waiting for async events");
                        }
                    }
                    if (!this.stopped) ** GOTO lbl23
                    if (this.eventQ.isEmpty()) {
                        AsyncEventSender.logger.info("AsyncEventSender.run: flush finished. stopped.");
                        // MONITOREXIT : var2_3
                        AsyncEventSender.logger.info("AsyncEventSender.run: quits (finally).");
                        return;
                    }
                    AsyncEventSender.logger.info("AsyncEventSender.run: flushing another event. (pending {})", (Object)this.eventQ.size());
lbl23:
                    // 2 sources

                    asyncEvent = this.eventQ.remove(0);
                    if (AsyncEventSender.logger.isDebugEnabled()) {
                        AsyncEventSender.logger.debug("AsyncEventSender.run: dequeued event {}, remaining: {}", (Object)asyncEvent, (Object)this.eventQ.size());
                    }
                    this.isSending = asyncEvent != null;
                    // MONITOREXIT : var2_3
                    if (asyncEvent == null) continue;
                    asyncEvent.trigger();
                    continue;
                    break;
                }
            }
            catch (Throwable th) {
                AsyncEventSender.logger.error("AsyncEventSender.run: Throwable occurred. Sleeping 5sec. Throwable: " + th, th);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    AsyncEventSender.logger.warn("AsyncEventSender.run: interrupted while sleeping");
                }
            }
        }
        catch (Throwable var5_6) {
            AsyncEventSender.logger.info("AsyncEventSender.run: quits (finally).");
            throw var5_6;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasInFlightEvent() {
        List<AsyncEvent> list = this.eventQ;
        synchronized (list) {
            return this.isSending || !this.eventQ.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInFlightEventCnt() {
        List<AsyncEvent> list = this.eventQ;
        synchronized (list) {
            int cnt = this.eventQ.size();
            if (this.isSending) {
                ++cnt;
            }
            return cnt;
        }
    }
}

