/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy;

import java.io.IOException;
import org.apache.lucene.facet.taxonomy.OrdinalsReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRef;

public class DocValuesOrdinalsReader
extends OrdinalsReader {
    private final String field;

    public DocValuesOrdinalsReader() {
        this("$facets");
    }

    public DocValuesOrdinalsReader(String field) {
        this.field = field;
    }

    @Override
    public OrdinalsReader.OrdinalsSegmentReader getReader(AtomicReaderContext context) throws IOException {
        BinaryDocValues values0 = context.reader().getBinaryDocValues(this.field);
        if (values0 == null) {
            values0 = BinaryDocValues.EMPTY;
        }
        final BinaryDocValues values = values0;
        return new OrdinalsReader.OrdinalsSegmentReader(){
            private final BytesRef bytes = new BytesRef(32);

            @Override
            public void get(int docID, IntsRef ordinals) throws IOException {
                values.get(docID, this.bytes);
                DocValuesOrdinalsReader.this.decode(this.bytes, ordinals);
            }
        };
    }

    @Override
    public String getIndexFieldName() {
        return this.field;
    }

    protected void decode(BytesRef buf, IntsRef ordinals) {
        if (ordinals.ints.length < buf.length) {
            ordinals.ints = ArrayUtil.grow(ordinals.ints, buf.length);
        }
        ordinals.offset = 0;
        ordinals.length = 0;
        int upto = buf.offset + buf.length;
        int value = 0;
        int offset = buf.offset;
        int prev = 0;
        while (offset < upto) {
            byte b;
            if ((b = buf.bytes[offset++]) >= 0) {
                ordinals.ints[ordinals.length] = (value << 7 | b) + prev;
                value = 0;
                prev = ordinals.ints[ordinals.length];
                ++ordinals.length;
                continue;
            }
            value = value << 7 | b & 0x7F;
        }
    }
}

