/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.principal;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import org.apache.jackrabbit.api.security.principal.GroupPrincipal;
import org.apache.jackrabbit.oak.spi.security.principal.GroupPrincipalWrapper;
import org.jetbrains.annotations.NotNull;

public final class GroupPrincipals {
    private static final GroupTransformer TRANSFORMER = new GroupTransformer();

    private GroupPrincipals() {
    }

    public static boolean isGroup(@NotNull Principal principal) {
        return principal instanceof Group || principal instanceof GroupPrincipal;
    }

    @NotNull
    public static Enumeration<? extends Principal> members(@NotNull Principal principal) {
        if (principal instanceof Group) {
            return ((Group)principal).members();
        }
        if (principal instanceof GroupPrincipal) {
            return ((GroupPrincipal)principal).members();
        }
        return Collections.emptyEnumeration();
    }

    public static boolean isMember(@NotNull Principal principal, @NotNull Principal member) {
        if (principal instanceof Group) {
            return ((Group)principal).isMember(member);
        }
        if (principal instanceof GroupPrincipal) {
            return ((GroupPrincipal)principal).isMember(member);
        }
        return false;
    }

    @NotNull
    public static Set<Principal> transform(@NotNull Set<Group> groups) {
        ImmutableSet.Builder g2 = ImmutableSet.builder();
        for (Group g : groups) {
            g2.add(new GroupPrincipalWrapper(g));
        }
        return g2.build();
    }

    @NotNull
    public static Enumeration<? extends Principal> transform(@NotNull Enumeration<? extends Principal> members) {
        Iterator<Principal> m2 = Iterators.transform(Iterators.forEnumeration(members), TRANSFORMER);
        return Iterators.asEnumeration(m2);
    }

    private static class GroupTransformer
    implements Function<Principal, Principal> {
        private GroupTransformer() {
        }

        @Override
        public Principal apply(Principal input) {
            if (input instanceof Group) {
                return new GroupPrincipalWrapper((Group)input);
            }
            return input;
        }
    }
}

