/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.version;

import com.google.common.base.Preconditions;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;

final class Utils {
    private Utils() {
    }

    @NotNull
    static String uuidFromNode(@NotNull NodeBuilder node) throws IllegalArgumentException {
        return Utils.uuidFromNode(node.getNodeState());
    }

    @NotNull
    static String uuidFromNode(@NotNull NodeState node) {
        PropertyState p = Preconditions.checkNotNull(node).getProperty("jcr:uuid");
        if (p == null) {
            throw new IllegalArgumentException("Not referenceable");
        }
        return p.getValue(Type.STRING);
    }

    @NotNull
    static String primaryTypeOf(@NotNull NodeBuilder node) throws IllegalStateException {
        String primaryType = Preconditions.checkNotNull(node).getName("jcr:primaryType");
        if (primaryType == null) {
            throw new IllegalStateException("Node does not have a jcr:primaryType");
        }
        return primaryType;
    }

    static <T> T throwProtected(String path) throws CommitFailedException {
        throw new CommitFailedException("Constraint", 100, "Item is protected: " + path);
    }
}

