/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.tree.factories;

import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.core.ImmutableRoot;
import org.apache.jackrabbit.oak.core.SystemRoot;
import org.apache.jackrabbit.oak.query.QueryEngineSettings;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.EmptyHook;
import org.apache.jackrabbit.oak.spi.query.CompositeQueryIndexProvider;
import org.apache.jackrabbit.oak.spi.query.QueryIndexProvider;
import org.apache.jackrabbit.oak.spi.security.OpenSecurityProvider;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RootFactory {
    private RootFactory() {
    }

    @NotNull
    public static Root createReadOnlyRoot(@NotNull NodeState rootState) {
        return new ImmutableRoot(rootState);
    }

    @NotNull
    public static Root createReadOnlyRoot(@NotNull Root root) {
        return ImmutableRoot.getInstance((Root)root);
    }

    @NotNull
    public static Root createSystemRoot(@NotNull NodeStore store, @Nullable CommitHook hook, @Nullable String workspaceName, @Nullable SecurityProvider securityProvider, @Nullable QueryEngineSettings queryEngineSettings, @Nullable QueryIndexProvider indexProvider) {
        return SystemRoot.create((NodeStore)store, (CommitHook)(hook == null ? EmptyHook.INSTANCE : hook), (String)(workspaceName == null ? "default" : workspaceName), (SecurityProvider)(securityProvider == null ? new OpenSecurityProvider() : securityProvider), (QueryEngineSettings)queryEngineSettings, (QueryIndexProvider)(indexProvider == null ? new CompositeQueryIndexProvider(new QueryIndexProvider[0]) : indexProvider));
    }

    @NotNull
    public static Root createSystemRoot(@NotNull NodeStore store, @Nullable CommitHook hook, @Nullable String workspaceName, @Nullable SecurityProvider securityProvider, @Nullable QueryIndexProvider indexProvider) {
        return SystemRoot.create((NodeStore)store, (CommitHook)(hook == null ? EmptyHook.INSTANCE : hook), (String)(workspaceName == null ? "default" : workspaceName), (SecurityProvider)(securityProvider == null ? new OpenSecurityProvider() : securityProvider), (QueryIndexProvider)(indexProvider == null ? new CompositeQueryIndexProvider(new QueryIndexProvider[0]) : indexProvider));
    }
}

