/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.migration;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Set;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.migration.FilteringNodeState;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.EmptyHook;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeStateCopier {
    private static final Logger LOG = LoggerFactory.getLogger(NodeStateCopier.class);
    private final Set<String> includePaths;
    private final Set<String> excludePaths;
    private final Set<String> fragmentPaths;
    private final Set<String> excludeFragments;
    private final Set<String> mergePaths;

    private NodeStateCopier(Set<String> includePaths, Set<String> excludePaths, Set<String> fragmentPaths, Set<String> excludeFragments, Set<String> mergePaths) {
        this.includePaths = includePaths;
        this.excludePaths = excludePaths;
        this.fragmentPaths = fragmentPaths;
        this.excludeFragments = excludeFragments;
        this.mergePaths = mergePaths;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static boolean copyNodeStore(@NotNull NodeStore source, @NotNull NodeStore target) throws CommitFailedException {
        return NodeStateCopier.builder().copy(Preconditions.checkNotNull(source), Preconditions.checkNotNull(target));
    }

    public static boolean copyProperties(NodeState source, NodeBuilder target) {
        boolean hasChanges = false;
        for (PropertyState propertyState : target.getProperties()) {
            String name = propertyState.getName();
            if (source.hasProperty(name)) continue;
            target.removeProperty(name);
            hasChanges = true;
        }
        for (PropertyState propertyState : source.getProperties()) {
            if (propertyState.equals(target.getProperty(propertyState.getName()))) continue;
            target.setProperty(propertyState);
            hasChanges = true;
        }
        return hasChanges;
    }

    private boolean copyNodeState(@NotNull NodeState sourceRoot, @NotNull NodeBuilder targetRoot) {
        NodeState wrappedSource = FilteringNodeState.wrap("/", sourceRoot, this.includePaths, this.excludePaths, this.fragmentPaths, this.excludeFragments);
        boolean hasChanges = false;
        for (String includePath : this.includePaths) {
            boolean bl = hasChanges = NodeStateCopier.copyMissingAncestors(sourceRoot, targetRoot, includePath) || hasChanges;
            NodeState sourceState = NodeStateUtils.getNode(wrappedSource, includePath);
            if (!sourceState.exists()) continue;
            NodeBuilder targetBuilder = NodeStateCopier.getChildNodeBuilder(targetRoot, includePath);
            hasChanges = NodeStateCopier.copyNodeState(sourceState, targetBuilder, includePath, this.mergePaths) || hasChanges;
        }
        return hasChanges;
    }

    private static boolean copyNodeState(@NotNull NodeState source, @NotNull NodeBuilder target, @NotNull String currentPath, @NotNull Set<String> mergePaths) {
        boolean hasChanges = false;
        for (String string : target.getChildNodeNames()) {
            if (source.hasChildNode(string) || NodeStateCopier.isMerge(PathUtils.concat(currentPath, string), mergePaths)) continue;
            target.setChildNode(string, EmptyNodeState.MISSING_NODE);
            hasChanges = true;
        }
        for (ChildNodeEntry childNodeEntry : source.getChildNodeEntries()) {
            String childPath;
            String childName = childNodeEntry.getName();
            NodeState childSource = childNodeEntry.getNodeState();
            if (!target.hasChildNode(childName)) {
                target.setChildNode(childName, childSource);
                hasChanges = true;
                continue;
            }
            NodeBuilder childTarget = target.getChildNode(childName);
            hasChanges = NodeStateCopier.copyNodeState(childSource, childTarget, childPath = PathUtils.concat(currentPath, childName), mergePaths) || hasChanges;
        }
        boolean bl = hasChanges = NodeStateCopier.copyProperties(source, target) || hasChanges;
        if (hasChanges) {
            LOG.trace("Node {} has changes", (Object)target);
        }
        return hasChanges;
    }

    private static boolean isMerge(String path, Set<String> mergePaths) {
        for (String mergePath : mergePaths) {
            if (!PathUtils.isAncestor(mergePath, path) && !mergePath.equals(path)) continue;
            return true;
        }
        return false;
    }

    private static boolean copyMissingAncestors(NodeState sourceRoot, NodeBuilder targetRoot, String path) {
        NodeState current = sourceRoot;
        NodeBuilder currentBuilder = targetRoot;
        boolean hasChanges = false;
        for (String name : PathUtils.elements(path)) {
            if (!current.hasChildNode(name)) continue;
            boolean targetHasChild = currentBuilder.hasChildNode(name);
            current = current.getChildNode(name);
            currentBuilder = currentBuilder.child(name);
            if (targetHasChild) continue;
            hasChanges = NodeStateCopier.copyProperties(current, currentBuilder) || hasChanges;
        }
        return hasChanges;
    }

    @NotNull
    private static NodeBuilder getChildNodeBuilder(@NotNull NodeBuilder root, @NotNull String path) {
        NodeBuilder child = root;
        for (String name : PathUtils.elements(path)) {
            child = child.child(name);
        }
        return child;
    }

    public static class Builder {
        private Set<String> includePaths = ImmutableSet.of("/");
        private Set<String> excludePaths = Collections.emptySet();
        private Set<String> fragmentPaths = Collections.emptySet();
        private Set<String> excludeFragments = Collections.emptySet();
        private Set<String> mergePaths = Collections.emptySet();

        private Builder() {
        }

        @NotNull
        public Builder include(@NotNull Set<String> paths) {
            if (!Preconditions.checkNotNull(paths).isEmpty()) {
                this.includePaths = ImmutableSet.copyOf(paths);
            }
            return this;
        }

        @NotNull
        public Builder include(String ... paths) {
            return this.include(ImmutableSet.copyOf((Object[])Preconditions.checkNotNull(paths)));
        }

        @NotNull
        public Builder exclude(@NotNull Set<String> paths) {
            if (!Preconditions.checkNotNull(paths).isEmpty()) {
                this.excludePaths = ImmutableSet.copyOf(paths);
            }
            return this;
        }

        @NotNull
        public Builder exclude(String ... paths) {
            return this.exclude(ImmutableSet.copyOf((Object[])Preconditions.checkNotNull(paths)));
        }

        @NotNull
        public Builder supportFragment(@NotNull Set<String> paths) {
            if (!Preconditions.checkNotNull(paths).isEmpty()) {
                this.fragmentPaths = ImmutableSet.copyOf(paths);
            }
            return this;
        }

        @NotNull
        public Builder supportFragment(String ... paths) {
            return this.supportFragment(ImmutableSet.copyOf((Object[])Preconditions.checkNotNull(paths)));
        }

        @NotNull
        public Builder excludeFragments(@NotNull Set<String> fragments) {
            if (!Preconditions.checkNotNull(fragments).isEmpty()) {
                this.excludeFragments = ImmutableSet.copyOf(fragments);
            }
            return this;
        }

        @NotNull
        public Builder excludeFragments(String ... fragments) {
            return this.exclude(ImmutableSet.copyOf((Object[])Preconditions.checkNotNull(fragments)));
        }

        @NotNull
        public Builder merge(@NotNull Set<String> paths) {
            if (!Preconditions.checkNotNull(paths).isEmpty()) {
                this.mergePaths = ImmutableSet.copyOf(paths);
            }
            return this;
        }

        @NotNull
        public Builder merge(String ... paths) {
            return this.merge(ImmutableSet.copyOf((Object[])Preconditions.checkNotNull(paths)));
        }

        public boolean copy(@NotNull NodeState sourceRoot, @NotNull NodeBuilder targetRoot) {
            NodeStateCopier copier = new NodeStateCopier(this.includePaths, this.excludePaths, this.fragmentPaths, this.excludeFragments, this.mergePaths);
            return copier.copyNodeState(Preconditions.checkNotNull(sourceRoot), Preconditions.checkNotNull(targetRoot));
        }

        public boolean copy(@NotNull NodeStore source, @NotNull NodeStore target) throws CommitFailedException {
            NodeBuilder targetRoot = Preconditions.checkNotNull(target).getRoot().builder();
            if (this.copy(Preconditions.checkNotNull(source).getRoot(), targetRoot)) {
                target.merge(targetRoot, EmptyHook.INSTANCE, CommitInfo.EMPTY);
                return true;
            }
            return false;
        }
    }
}

