/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.util;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.lucene.document.Document;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.LabelAndValue;
import org.apache.lucene.facet.sortedset.DefaultSortedSetDocValuesReaderState;
import org.apache.lucene.facet.sortedset.SortedSetDocValuesFacetCounts;
import org.apache.lucene.facet.sortedset.SortedSetDocValuesReaderState;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.jetbrains.annotations.NotNull;

class SecureSortedSetDocValuesFacetCounts
extends SortedSetDocValuesFacetCounts {
    private final FacetsCollector facetsCollector;
    private final Filter filter;
    private final IndexReader reader;
    private final SortedSetDocValuesReaderState state;
    private FacetResult facetResult = null;

    SecureSortedSetDocValuesFacetCounts(DefaultSortedSetDocValuesReaderState state, FacetsCollector facetsCollector, Filter filter) throws IOException {
        super(state, facetsCollector);
        this.reader = state.origReader;
        this.facetsCollector = facetsCollector;
        this.filter = filter;
        this.state = state;
    }

    @Override
    public FacetResult getTopChildren(int topN, String dim, String ... path) throws IOException {
        if (this.facetResult == null) {
            this.facetResult = this.getTopChildren0(topN, dim, path);
        }
        return this.facetResult;
    }

    private FacetResult getTopChildren0(int topN, String dim, String ... path) throws IOException {
        FacetResult topChildren = super.getTopChildren(topN, dim, path);
        if (topChildren == null) {
            return null;
        }
        InaccessibleFacetCountManager inaccessibleFacetCountManager = new InaccessibleFacetCountManager(dim, this.reader, this.filter, this.state, this.facetsCollector, topChildren.labelValues);
        inaccessibleFacetCountManager.filterFacets();
        LabelAndValue[] labelAndValues = inaccessibleFacetCountManager.updateLabelAndValue();
        int childCount = labelAndValues.length;
        Number value = 0;
        for (LabelAndValue lv : labelAndValues) {
            value = ((Number)value).longValue() + lv.value.longValue();
        }
        return new FacetResult(dim, path, value, labelAndValues, childCount);
    }

    static class InaccessibleFacetCountManager {
        private final String dimension;
        private final IndexReader reader;
        private final Filter filter;
        private final SortedSetDocValuesReaderState state;
        private final FacetsCollector facetsCollector;
        private final LabelAndValue[] labelAndValues;
        private final Map<String, Integer> labelToIndexMap;
        private final long[] inaccessibleCounts;

        InaccessibleFacetCountManager(String dimension, IndexReader reader, Filter filter, SortedSetDocValuesReaderState state, FacetsCollector facetsCollector, LabelAndValue[] labelAndValues) {
            this.dimension = dimension;
            this.reader = reader;
            this.filter = filter;
            this.state = state;
            this.facetsCollector = facetsCollector;
            this.labelAndValues = labelAndValues;
            this.inaccessibleCounts = new long[labelAndValues.length];
            HashMap<String, Integer> map = Maps.newHashMap();
            for (int i = 0; i < labelAndValues.length; ++i) {
                LabelAndValue lv = labelAndValues[i];
                map.put(lv.label, i);
            }
            this.labelToIndexMap = Collections.unmodifiableMap(map);
        }

        void filterFacets() throws IOException {
            List<FacetsCollector.MatchingDocs> matchingDocsList = this.facetsCollector.getMatchingDocs();
            for (FacetsCollector.MatchingDocs matchingDocs : matchingDocsList) {
                DocIdSet bits = matchingDocs.bits;
                DocIdSetIterator docIdSetIterator = bits.iterator();
                int doc = docIdSetIterator.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    int docId = matchingDocs.context.docBase + doc;
                    this.filterFacet(docId);
                    doc = docIdSetIterator.nextDoc();
                }
            }
        }

        private void filterFacet(int docId) throws IOException {
            Document document = this.reader.document(docId);
            if (!this.filter.isAccessible(document.getField(":path").stringValue() + "/" + this.dimension)) {
                SortedSetDocValues docValues = this.state.getDocValues();
                docValues.setDocument(docId);
                TermsEnum termsEnum = docValues.termsEnum();
                long ord = docValues.nextOrd();
                while (ord != -1L) {
                    termsEnum.seekExact(ord);
                    String facetDVTerm = termsEnum.term().utf8ToString();
                    String[] facetDVDimPaths = FacetsConfig.stringToPath(facetDVTerm);
                    for (int i = 1; i < facetDVDimPaths.length; ++i) {
                        this.markInaccessbile(facetDVDimPaths[i]);
                    }
                    ord = docValues.nextOrd();
                }
            }
        }

        void markInaccessbile(@NotNull String label) {
            int n = this.labelToIndexMap.get(label);
            this.inaccessibleCounts[n] = this.inaccessibleCounts[n] + 1L;
        }

        LabelAndValue[] updateLabelAndValue() {
            LabelAndValue[] newValues;
            int i;
            int numZeros = 0;
            for (i = 0; i < this.labelAndValues.length; ++i) {
                LabelAndValue lv = this.labelAndValues[i];
                long inaccessibleCount = this.inaccessibleCounts[this.labelToIndexMap.get(lv.label)];
                if (inaccessibleCount <= 0L) continue;
                long newValue = lv.value.longValue() - inaccessibleCount;
                if (newValue <= 0L) {
                    newValue = 0L;
                    ++numZeros;
                }
                this.labelAndValues[i] = new LabelAndValue(lv.label, newValue);
            }
            if (numZeros > 0) {
                newValues = new LabelAndValue[this.labelAndValues.length - numZeros];
                i = 0;
                for (LabelAndValue lv : this.labelAndValues) {
                    if (lv.value.longValue() <= 0L) continue;
                    newValues[i++] = lv;
                }
            } else {
                newValues = this.labelAndValues;
            }
            return newValues;
        }
    }
}

