/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.util;

import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.lucene.facet.FacetsConfig;

class NodeStateFacetsConfig
extends FacetsConfig {
    private static final String MULTIVALUED = "multivalued";
    private final NodeBuilder nodeBuilder;

    NodeStateFacetsConfig(NodeBuilder nodeBuilder) {
        this.nodeBuilder = nodeBuilder.child("facets");
        if (!this.nodeBuilder.hasProperty("jcr:primaryType")) {
            this.nodeBuilder.setProperty("jcr:primaryType", "nt:unstructured", Type.NAME);
        }
        NodeBuilder current = this.nodeBuilder;
        String prefix = "";
        this.readMVFacets(current, prefix);
    }

    private void readMVFacets(NodeBuilder current, String prefix) {
        for (String childName : current.getChildNodeNames()) {
            NodeBuilder child = current.child(childName);
            super.setMultiValued(childName, child.getProperty(MULTIVALUED).getValue(Type.BOOLEAN));
            if (prefix.length() <= 0) continue;
            super.setMultiValued(prefix + "/" + childName, child.getProperty(MULTIVALUED).getValue(Type.BOOLEAN));
            this.readMVFacets(child, childName);
        }
    }

    @Override
    public synchronized void setMultiValued(String dimName, boolean v) {
        super.setMultiValued(dimName, v);
        if (v) {
            NodeBuilder current = this.nodeBuilder;
            for (String p : PathUtils.elements(dimName)) {
                NodeBuilder child = current.child(p);
                if (!child.hasProperty("jcr:primaryType")) {
                    child.setProperty("jcr:primaryType", "nt:unstructured", Type.NAME);
                }
                child.setProperty(MULTIVALUED, true);
                current = child;
            }
        }
    }
}

