/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.ContextAwareCallback;
import org.apache.jackrabbit.oak.plugins.index.CorruptIndexHandler;
import org.apache.jackrabbit.oak.plugins.index.IndexCommitCallback;
import org.apache.jackrabbit.oak.plugins.index.IndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdateCallback;
import org.apache.jackrabbit.oak.plugins.index.IndexUtils;
import org.apache.jackrabbit.oak.plugins.index.IndexingContext;
import org.apache.jackrabbit.oak.plugins.index.NodeTraversalCallback;
import org.apache.jackrabbit.oak.plugins.index.progress.IndexingProgressReporter;
import org.apache.jackrabbit.oak.plugins.index.progress.NodeCountEstimator;
import org.apache.jackrabbit.oak.plugins.index.progress.TraversalRateEstimator;
import org.apache.jackrabbit.oak.plugins.index.upgrade.IndexDisabler;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.CompositeEditor;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.commit.EditorDiff;
import org.apache.jackrabbit.oak.spi.commit.VisibleEditor;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.apache.jackrabbit.oak.spi.state.ReadOnlyBuilder;
import org.apache.jackrabbit.util.ISO8601;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexUpdate
implements Editor,
NodeTraversalCallback.PathSource {
    private static final Logger log = LoggerFactory.getLogger(IndexUpdate.class);
    static final boolean IGNORE_REINDEX_FLAGS = Boolean.getBoolean("oak.indexUpdate.ignoreReindexFlags");
    private final IndexUpdateRootState rootState;
    private final NodeBuilder builder;
    private final IndexUpdate parent;
    private final String name;
    private String path;
    private final List<Editor> editors = Lists.newArrayList();
    private final Map<String, Editor> reindex = new HashMap<String, Editor>();

    public IndexUpdate(IndexEditorProvider provider, String async, NodeState root, NodeBuilder builder, IndexUpdateCallback updateCallback) {
        this(provider, async, root, builder, updateCallback, CommitInfo.EMPTY);
    }

    public IndexUpdate(IndexEditorProvider provider, String async, NodeState root, NodeBuilder builder, IndexUpdateCallback updateCallback, CommitInfo commitInfo) {
        this(provider, async, root, builder, updateCallback, NodeTraversalCallback.NOOP, commitInfo, CorruptIndexHandler.NOOP);
    }

    public IndexUpdate(IndexEditorProvider provider, String async, NodeState root, NodeBuilder builder, IndexUpdateCallback updateCallback, NodeTraversalCallback traversalCallback, CommitInfo commitInfo, CorruptIndexHandler corruptIndexHandler) {
        this.parent = null;
        this.name = null;
        this.path = "/";
        this.rootState = new IndexUpdateRootState(provider, async, root, builder, updateCallback, traversalCallback, commitInfo, corruptIndexHandler);
        this.builder = Preconditions.checkNotNull(builder);
    }

    private IndexUpdate(IndexUpdate parent, String name) {
        this.parent = Preconditions.checkNotNull(parent);
        this.name = name;
        this.rootState = parent.rootState;
        this.builder = parent.builder.getChildNode(Preconditions.checkNotNull(name));
    }

    @Override
    public void enter(NodeState before, NodeState after) throws CommitFailedException {
        this.rootState.nodeRead(this);
        this.collectIndexEditors(this.builder.getChildNode("oak:index"), before);
        if (!this.reindex.isEmpty()) {
            log.info("Reindexing will be performed for following indexes: {}", (Object)this.reindex.keySet());
            this.rootState.progressReporter.reindexingTraversalStart(this.getPath());
        }
        CommitFailedException exception = EditorDiff.process(VisibleEditor.wrap(this.wrapProgress(CompositeEditor.compose(this.reindex.values()))), EmptyNodeState.MISSING_NODE, after);
        this.rootState.progressReporter.reindexingTraversalEnd();
        if (exception != null) {
            throw exception;
        }
        for (Editor editor : this.editors) {
            editor.enter(before, after);
        }
    }

    public boolean isReindexingPerformed() {
        return !this.getReindexStats().isEmpty();
    }

    public List<String> getReindexStats() {
        return this.rootState.progressReporter.getReindexStats();
    }

    public Set<String> getUpdatedIndexPaths() {
        return this.rootState.progressReporter.getUpdatedIndexPaths();
    }

    public void setTraversalRateEstimator(TraversalRateEstimator estimator) {
        this.rootState.progressReporter.setTraversalRateEstimator(estimator);
    }

    public void setNodeCountEstimator(NodeCountEstimator nodeCountEstimator) {
        this.rootState.progressReporter.setNodeCountEstimator(nodeCountEstimator);
    }

    public String getIndexingStats() {
        return this.rootState.getIndexingStats();
    }

    public void setIgnoreReindexFlags(boolean ignoreReindexFlag) {
        this.rootState.setIgnoreReindexFlags(ignoreReindexFlag);
    }

    private boolean shouldReindex(NodeBuilder definition, NodeState before, String name) {
        boolean result;
        if (!this.isMatchingIndexMode(definition)) {
            return false;
        }
        PropertyState type = definition.getProperty("type");
        if (type != null && "disabled".equals(type.getValue(Type.STRING))) {
            return false;
        }
        PropertyState ps = definition.getProperty("reindex");
        if (ps != null && ps.getValue(Type.BOOLEAN).booleanValue()) {
            return !this.rootState.ignoreReindexFlags;
        }
        boolean bl = result = !before.getChildNode("oak:index").hasChildNode(name) && !IndexUpdate.hasAnyHiddenNodes(definition);
        if (result) {
            log.info("Found a new index node [{}]. Reindexing is requested", (Object)name);
        }
        return result;
    }

    private static boolean hasAnyHiddenNodes(NodeBuilder builder) {
        for (String name : builder.getChildNodeNames()) {
            NodeBuilder childNode;
            if (!NodeStateUtils.isHidden(name) || (childNode = builder.getChildNode(name)).getBoolean("retainNodeInReindex")) continue;
            return true;
        }
        return false;
    }

    private void collectIndexEditors(NodeBuilder definitions, NodeState before) throws CommitFailedException {
        for (String name : definitions.getChildNodeNames()) {
            String type;
            NodeBuilder definition = definitions.getChildNode(name);
            if (!IndexUpdate.isIncluded(this.rootState.async, definition) || (type = definition.getString("type")) == null) continue;
            boolean shouldReindex = this.shouldReindex(definition, before, name);
            String indexPath = IndexUpdate.getIndexPath(this.getPath(), name);
            if (definition.hasProperty("corrupt") && !shouldReindex) {
                String corruptSince = definition.getProperty("corrupt").getValue(Type.DATE);
                this.rootState.corruptIndexHandler.skippingCorruptIndex(this.rootState.async, indexPath, ISO8601.parse(corruptSince));
                continue;
            }
            Editor editor = null;
            try {
                editor = this.rootState.provider.getIndexEditor(type, definition, this.rootState.root, this.rootState.newCallback(indexPath, shouldReindex, this.getEstimatedCount(definition)));
            }
            catch (IllegalStateException e) {
                log.error("Unable to get Index Editor for index at {} . Please correct the index definition and reindex after correction. Additional Info : {}", indexPath, e.getMessage(), e);
                continue;
            }
            if (editor == null) {
                if (definition.hasProperty("async") && this.rootState.async == null) {
                    log.warn("Missing provider for nrt/sync index: {} (rootState.async: {}). Please note, it means that index data should be trusted only after this index is processed in an async indexing cycle.", (Object)definition, (Object)this.rootState.async);
                    continue;
                }
                this.rootState.missingProvider.onMissingIndex(type, definition, indexPath);
                continue;
            }
            if (shouldReindex) {
                if (definition.getBoolean("reindex-async") && definition.getString("async") == null) {
                    definition.setProperty("async", "async-reindex");
                } else {
                    definition.setProperty("reindex", false);
                    this.incrementReIndexCount(definition);
                    this.removeIndexState(definition);
                    this.clearCorruptFlag(definition, indexPath);
                    this.reindex.put(PathUtils.concat(this.getPath(), "oak:index", name), editor);
                }
                this.rootState.indexDisabler.markDisableFlagIfRequired(indexPath, definition);
                continue;
            }
            if (IndexUtils.getAsyncLaneName(definition.getNodeState(), indexPath) == null || this.rootState.async != null) {
                this.rootState.indexDisabler.disableOldIndexes(indexPath, definition);
            }
            this.editors.add(editor);
        }
    }

    private void removeIndexState(NodeBuilder definition) {
        for (String rm : definition.getChildNodeNames()) {
            NodeBuilder childNode;
            if (!NodeStateUtils.isHidden(rm) || (childNode = definition.getChildNode(rm)).getBoolean("retainNodeInReindex")) continue;
            NodeBuilder child = definition.getChildNode(rm);
            if (child instanceof ReadOnlyBuilder) {
                log.debug("Preserve read-only child node on reindex: " + rm);
                continue;
            }
            child.remove();
        }
    }

    private long getEstimatedCount(NodeBuilder indexDefinition) {
        return -1L;
    }

    static boolean isIncluded(String asyncRef, NodeBuilder definition) {
        if (definition.hasProperty("async")) {
            PropertyState p = definition.getProperty("async");
            Iterable<String> opt = p.getValue(Type.STRINGS);
            if (asyncRef == null) {
                return Iterables.contains(opt, "nrt") || Iterables.contains(opt, "sync");
            }
            return Iterables.contains(opt, asyncRef);
        }
        return asyncRef == null;
    }

    private boolean isMatchingIndexMode(NodeBuilder definition) {
        boolean async = definition.hasProperty("async");
        return async == this.rootState.isAsync();
    }

    private void incrementReIndexCount(NodeBuilder definition) {
        long count = 0L;
        if (definition.hasProperty("reindexCount")) {
            count = definition.getProperty("reindexCount").getValue(Type.LONG);
        }
        definition.setProperty("reindexCount", count + 1L);
    }

    @Override
    public String getPath() {
        if (this.path == null) {
            this.path = PathUtils.concat(this.parent.getPath(), this.name);
        }
        return this.path;
    }

    @Override
    public void leave(NodeState before, NodeState after) throws CommitFailedException {
        for (Editor editor : this.editors) {
            editor.leave(before, after);
        }
        if (this.parent == null) {
            this.rootState.progressReporter.logReport();
        }
    }

    @Override
    public void propertyAdded(PropertyState after) throws CommitFailedException {
        this.rootState.propertyChanged(after.getName());
        for (Editor editor : this.editors) {
            editor.propertyAdded(after);
        }
    }

    @Override
    public void propertyChanged(PropertyState before, PropertyState after) throws CommitFailedException {
        this.rootState.propertyChanged(before.getName());
        for (Editor editor : this.editors) {
            editor.propertyChanged(before, after);
        }
    }

    @Override
    public void propertyDeleted(PropertyState before) throws CommitFailedException {
        this.rootState.propertyChanged(before.getName());
        for (Editor editor : this.editors) {
            editor.propertyDeleted(before);
        }
    }

    @Override
    @NotNull
    public Editor childNodeAdded(String name, NodeState after) throws CommitFailedException {
        ArrayList<Editor> children = Lists.newArrayListWithCapacity(1 + this.editors.size());
        children.add(new IndexUpdate(this, name));
        for (Editor editor : this.editors) {
            Editor child = editor.childNodeAdded(name, after);
            if (child == null) continue;
            children.add(child);
        }
        return CompositeEditor.compose(children);
    }

    @Override
    @NotNull
    public Editor childNodeChanged(String name, NodeState before, NodeState after) throws CommitFailedException {
        ArrayList<Editor> children = Lists.newArrayListWithCapacity(1 + this.editors.size());
        children.add(new IndexUpdate(this, name));
        for (Editor editor : this.editors) {
            Editor child = editor.childNodeChanged(name, before, after);
            if (child == null) continue;
            children.add(child);
        }
        return CompositeEditor.compose(children);
    }

    @Override
    @Nullable
    public Editor childNodeDeleted(String name, NodeState before) throws CommitFailedException {
        ArrayList<Editor> children = Lists.newArrayListWithCapacity(this.editors.size());
        for (Editor editor : this.editors) {
            Editor child = editor.childNodeDeleted(name, before);
            if (child == null) continue;
            children.add(child);
        }
        return CompositeEditor.compose(children);
    }

    public void commitProgress(IndexCommitCallback.IndexProgress indexProgress) {
        this.rootState.commitProgress(indexProgress);
    }

    protected Set<String> getReindexedDefinitions() {
        return this.rootState.progressReporter.getReindexedIndexPaths();
    }

    private void clearCorruptFlag(NodeBuilder definition, String indexPath) {
        PropertyState corrupt = definition.getProperty("corrupt");
        if (corrupt != null) {
            definition.removeProperty("corrupt");
            log.info("Removing corrupt flag from index [{}] which has been marked as corrupt since [{}]", (Object)indexPath, (Object)corrupt.getValue(Type.DATE));
        }
    }

    private static String getIndexPath(String path, String indexName) {
        if (PathUtils.denotesRoot(path)) {
            return "/oak:index/" + indexName;
        }
        return path + "/" + "oak:index" + "/" + indexName;
    }

    private Editor wrapProgress(Editor editor) {
        return this.rootState.progressReporter.wrapProgress(editor);
    }

    public IndexUpdate withMissingProviderStrategy(MissingIndexProviderStrategy missingProvider) {
        this.rootState.setMissingProvider(missingProvider);
        return this;
    }

    static {
        if (IGNORE_REINDEX_FLAGS) {
            log.warn("Reindexing is disabled by configuration. This value is configurable via the 'oak.indexUpdate.ignoreReindexFlags' system property.");
        }
    }

    private static final class IndexUpdateRootState {
        final IndexEditorProvider provider;
        final String async;
        final NodeState root;
        final CommitInfo commitInfo;
        final IndexDisabler indexDisabler;
        private boolean ignoreReindexFlags = IGNORE_REINDEX_FLAGS;
        final Set<IndexCommitCallback> indexCommitCallbacks = Sets.newIdentityHashSet();
        final CorruptIndexHandler corruptIndexHandler;
        final IndexingProgressReporter progressReporter;
        private int changedNodeCount;
        private int changedPropertyCount;
        private MissingIndexProviderStrategy missingProvider = new MissingIndexProviderStrategy();

        private IndexUpdateRootState(IndexEditorProvider provider, String async, NodeState root, NodeBuilder builder, IndexUpdateCallback updateCallback, NodeTraversalCallback traversalCallback, CommitInfo commitInfo, CorruptIndexHandler corruptIndexHandler) {
            this.provider = Preconditions.checkNotNull(provider);
            this.async = async;
            this.root = Preconditions.checkNotNull(root);
            this.commitInfo = commitInfo;
            this.corruptIndexHandler = corruptIndexHandler;
            this.indexDisabler = new IndexDisabler(builder);
            this.progressReporter = new IndexingProgressReporter(updateCallback, traversalCallback);
        }

        public IndexUpdateCallback newCallback(String indexPath, boolean reindex, long estimatedCount) {
            this.progressReporter.registerIndex(indexPath, reindex, estimatedCount);
            return new ReportingCallback(indexPath, reindex);
        }

        public boolean isAsync() {
            return this.async != null;
        }

        public void nodeRead(NodeTraversalCallback.PathSource pathSource) throws CommitFailedException {
            ++this.changedNodeCount;
            this.progressReporter.traversedNode(pathSource);
        }

        public void propertyChanged(String name) {
            ++this.changedPropertyCount;
        }

        public String getIndexingStats() {
            return String.format("changedNodeCount %d, changedPropertyCount %d", this.changedNodeCount, this.changedPropertyCount);
        }

        public void setMissingProvider(MissingIndexProviderStrategy missingProvider) {
            this.missingProvider = missingProvider;
        }

        void setIgnoreReindexFlags(boolean ignoreReindexFlags) {
            this.ignoreReindexFlags = ignoreReindexFlags;
        }

        void registerIndexCommitCallbackInternal(IndexCommitCallback callback) {
            this.indexCommitCallbacks.add(callback);
        }

        public void commitProgress(IndexCommitCallback.IndexProgress indexProgress) {
            for (IndexCommitCallback icc : this.indexCommitCallbacks) {
                try {
                    icc.commitProgress(indexProgress);
                }
                catch (Exception e) {
                    log.warn("Commit progress callback threw an exception. Saving ourselves.", e);
                }
            }
        }

        private class ReportingCallback
        implements ContextAwareCallback,
        IndexingContext {
            final String indexPath;
            final boolean reindex;

            public ReportingCallback(String indexPath, boolean reindex) {
                this.indexPath = indexPath;
                this.reindex = reindex;
            }

            @Override
            public void indexUpdate() throws CommitFailedException {
                IndexUpdateRootState.this.progressReporter.indexUpdate(this.indexPath);
            }

            @Override
            public IndexingContext getIndexingContext() {
                return this;
            }

            @Override
            public String getIndexPath() {
                return this.indexPath;
            }

            @Override
            public CommitInfo getCommitInfo() {
                return IndexUpdateRootState.this.commitInfo;
            }

            @Override
            public boolean isReindexing() {
                return this.reindex;
            }

            @Override
            public boolean isAsync() {
                return IndexUpdateRootState.this.isAsync();
            }

            @Override
            public void indexUpdateFailed(Exception e) {
                IndexUpdateRootState.this.corruptIndexHandler.indexUpdateFailed(IndexUpdateRootState.this.async, this.indexPath, e);
            }

            @Override
            public void registerIndexCommitCallback(IndexCommitCallback callback) {
                IndexUpdateRootState.this.registerIndexCommitCallbackInternal(callback);
            }
        }
    }

    public static class MissingIndexProviderStrategy {
        private boolean failOnMissingIndexProvider = Boolean.getBoolean("oak.indexUpdate.failOnMissingIndexProvider");
        private final Set<String> ignore = Sets.newHashSet("disabled", "ordered");

        public void onMissingIndex(String type, NodeBuilder definition, String indexPath) throws CommitFailedException {
            if (this.isDisabled(type)) {
                return;
            }
            PropertyState ps = definition.getProperty("reindex");
            if (ps != null && ps.getValue(Type.BOOLEAN).booleanValue()) {
                return;
            }
            if (this.failOnMissingIndexProvider) {
                throw new CommitFailedException("IndexUpdate", 1, "Missing index provider detected for type [" + type + "] on index [" + indexPath + "]");
            }
            log.warn("Missing index provider of type [{}], requesting reindex on [{}]", (Object)type, (Object)indexPath);
            definition.setProperty("reindex", true);
        }

        boolean isDisabled(String type) {
            return this.ignore.contains(type);
        }

        void setFailOnMissingIndexProvider(boolean failOnMissingIndexProvider) {
            this.failOnMissingIndexProvider = failOnMissingIndexProvider;
        }
    }
}

