/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index;

import com.google.common.collect.ImmutableMap;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.api.jmx.IndexStatsMBean;
import org.apache.jackrabbit.oak.plugins.index.AsyncIndexInfo;
import org.apache.jackrabbit.oak.plugins.index.AsyncIndexInfoService;
import org.apache.jackrabbit.oak.plugins.index.AsyncIndexUpdate;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.util.ISO8601;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component
public class AsyncIndexInfoServiceImpl
implements AsyncIndexInfoService {
    private final Map<String, IndexStatsMBean> statsMBeans = new ConcurrentHashMap<String, IndexStatsMBean>();
    @Reference
    private NodeStore nodeStore;

    public AsyncIndexInfoServiceImpl() {
    }

    public AsyncIndexInfoServiceImpl(NodeStore nodeStore) {
        this.nodeStore = nodeStore;
    }

    @Override
    public Iterable<String> getAsyncLanes() {
        return this.getAsyncLanes(this.nodeStore.getRoot());
    }

    @Override
    public Iterable<String> getAsyncLanes(NodeState root) {
        NodeState async = this.getAsyncState(root);
        HashSet<String> names = new HashSet<String>();
        for (PropertyState propertyState : async.getProperties()) {
            String name = propertyState.getName();
            if (!AsyncIndexUpdate.isAsyncLaneName(name)) continue;
            names.add(name);
        }
        return names;
    }

    @Override
    public AsyncIndexInfo getInfo(String name) {
        return this.getInfo(name, this.nodeStore.getRoot());
    }

    @Override
    public AsyncIndexInfo getInfo(String name, NodeState root) {
        NodeState async = this.getAsyncState(root);
        if (async.hasProperty(name)) {
            long lastIndexedTo = AsyncIndexInfoServiceImpl.getLastIndexedTo(name, async);
            long leaseEnd = -1L;
            boolean running = false;
            if (async.hasProperty(AsyncIndexUpdate.leasify(name))) {
                running = true;
                leaseEnd = async.getLong(AsyncIndexUpdate.leasify(name));
            }
            IndexStatsMBean mbean = this.statsMBeans.get(name);
            return new AsyncIndexInfo(name, lastIndexedTo, leaseEnd, running, mbean);
        }
        return null;
    }

    @Override
    public Map<String, Long> getIndexedUptoPerLane() {
        return this.getIndexedUptoPerLane(this.nodeStore.getRoot());
    }

    @Override
    public Map<String, Long> getIndexedUptoPerLane(NodeState root) {
        ImmutableMap.Builder<String, Long> builder = new ImmutableMap.Builder<String, Long>();
        NodeState async = this.getAsyncState(root);
        for (PropertyState propertyState : async.getProperties()) {
            String name = propertyState.getName();
            if (!AsyncIndexUpdate.isAsyncLaneName(name)) continue;
            long lastIndexedTo = AsyncIndexInfoServiceImpl.getLastIndexedTo(name, async);
            builder.put(name, lastIndexedTo);
        }
        return builder.build();
    }

    private NodeState getAsyncState(NodeState root) {
        return root.getChildNode(":async");
    }

    @Reference(name="statsMBeans", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.GREEDY, service=IndexStatsMBean.class)
    protected void bindStatsMBeans(IndexStatsMBean mBean) {
        this.statsMBeans.put(mBean.getName(), mBean);
    }

    protected void unbindStatsMBeans(IndexStatsMBean mBean) {
        this.statsMBeans.remove(mBean.getName());
    }

    private static long getLastIndexedTo(String name, NodeState async) {
        return AsyncIndexInfoServiceImpl.getDateAsMillis(async.getProperty(AsyncIndexUpdate.lastIndexedTo(name)));
    }

    private static long getDateAsMillis(PropertyState ps) {
        if (ps == null) {
            return -1L;
        }
        String date = ps.getValue(Type.DATE);
        Calendar cal = ISO8601.parse(date);
        return cal.getTimeInMillis();
    }
}

