/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.RepositoryFactory;
import org.apache.jackrabbit.oak.jcr.Jcr;

public class OakRepositoryFactory
implements RepositoryFactory {
    private static final String REPOSITORY_URI = "org.apache.jackrabbit.repository.uri";

    @Override
    public Repository getRepository(Map parameters) throws RepositoryException {
        Object value;
        Object object = value = parameters == null ? null : (Object)parameters.get(REPOSITORY_URI);
        if (value != null) {
            try {
                URI uri = new URI(value.toString());
                if (uri.getScheme().equalsIgnoreCase("jcr-oak")) {
                    return OakRepositoryFactory.getRepository(uri, parameters);
                }
            }
            catch (URISyntaxException uRISyntaxException) {}
        } else {
            return OakRepositoryFactory.getRepository(null, null);
        }
        return null;
    }

    private static Repository getRepository(URI uri, Map<String, String> parameters) throws RepositoryException {
        return new Jcr().createRepository();
    }
}

