/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.composite.checks;

import java.util.ArrayList;
import java.util.List;
import org.apache.jackrabbit.oak.api.IllegalRepositoryStateException;
import org.apache.jackrabbit.oak.composite.MountedNodeStore;

class ErrorHolder {
    private static final int FAIL_IMMEDIATELY_THRESHOLD = 100;
    private final List<String> errors = new ArrayList<String>();

    ErrorHolder() {
    }

    public void report(MountedNodeStore mountedStore, String path, String error) {
        this.errors.add(String.format("For NodeStore mount %s, path %s, encountered the following problem: '%s'", mountedStore.getMount().getName(), path, error));
        if (this.errors.size() == 100) {
            this.end();
        }
    }

    public void report(MountedNodeStore firstNS, String firstPath, MountedNodeStore secondNS, String secondPath, String value, String error) {
        this.errors.add(String.format("For NodeStore mount %s, path %s, and NodeStore mount %s, path %s, encountered the following clash for value %s: '%s'", firstNS.getMount().getName(), firstPath, secondNS.getMount().getName(), secondPath, value, error));
        if (this.errors.size() == 100) {
            this.end();
        }
    }

    public void end() {
        if (this.errors.isEmpty()) {
            return;
        }
        StringBuilder out = new StringBuilder();
        out.append(this.errors.size()).append(" errors were found: \n");
        this.errors.forEach(e -> out.append((String)e).append('\n'));
        throw new IllegalRepositoryStateException(out.toString());
    }
}

