/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.api;

import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.NamespaceException;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.security.AccessControlException;
import javax.jcr.version.LabelExistsVersionException;
import javax.jcr.version.VersionException;
import org.jetbrains.annotations.NotNull;

public class CommitFailedException
extends Exception {
    public static final String OAK = "Oak";
    public static final String ACCESS = "Access";
    public static final String ACCESS_CONTROL = "AccessControl";
    public static final String CONSTRAINT = "Constraint";
    public static final String INTEGRITY = "Integrity";
    public static final String LOCK = "Lock";
    public static final String NAME = "Name";
    public static final String NAMESPACE = "Namespace";
    public static final String NODE_TYPE = "NodeType";
    public static final String STATE = "State";
    public static final String VERSION = "Version";
    public static final String LABEL_EXISTS = "LabelExists";
    public static final String MERGE = "Merge";
    public static final String UNSUPPORTED = "Unsupported";
    private static final long serialVersionUID = 2727602333350620918L;
    private final String source;
    private final String type;
    private final int code;

    public CommitFailedException(String source, String type, int code, String message, Throwable cause) {
        super(String.format("%s%s%04d: %s", source, type, code, message), cause);
        this.source = source;
        this.type = type;
        this.code = code;
    }

    public CommitFailedException(String type, int code, String message, Throwable cause) {
        this(OAK, type, code, message, cause);
    }

    public CommitFailedException(String type, int code, String message) {
        this(type, code, message, null);
    }

    public boolean isOfType(String type) {
        return this.type.equals(type);
    }

    public boolean isAccessViolation() {
        return this.isOfType(ACCESS);
    }

    public boolean isAccessControlViolation() {
        return this.isOfType(ACCESS_CONTROL);
    }

    public boolean isConstraintViolation() {
        return this.isOfType(CONSTRAINT);
    }

    public String getSource() {
        return this.source;
    }

    public String getType() {
        return this.type;
    }

    public int getCode() {
        return this.code;
    }

    public RepositoryException asRepositoryException() {
        return this.asRepositoryException(this.getMessage());
    }

    public RepositoryException asRepositoryException(@NotNull String message) {
        if (this.isConstraintViolation()) {
            return new ConstraintViolationException(message, this);
        }
        if (this.isOfType(NAMESPACE)) {
            return new NamespaceException(message, this);
        }
        if (this.isOfType(NODE_TYPE)) {
            return new NoSuchNodeTypeException(message, this);
        }
        if (this.isAccessViolation()) {
            return new AccessDeniedException(message, this);
        }
        if (this.isAccessControlViolation()) {
            return new AccessControlException(message, this);
        }
        if (this.isOfType(INTEGRITY)) {
            return new ReferentialIntegrityException(message, this);
        }
        if (this.isOfType(STATE)) {
            return new InvalidItemStateException(message, this);
        }
        if (this.isOfType(MERGE)) {
            return new InvalidItemStateException(message, this);
        }
        if (this.isOfType(VERSION)) {
            return new VersionException(message, this);
        }
        if (this.isOfType(LABEL_EXISTS)) {
            return new LabelExistsVersionException(message, this);
        }
        if (this.isOfType(LOCK)) {
            return new LockException(message, this);
        }
        if (this.isOfType(UNSUPPORTED)) {
            return new UnsupportedRepositoryOperationException(message, this);
        }
        return new RepositoryException(message, this);
    }
}

