/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.transaction.manager;

import java.util.HashMap;
import java.util.Map;
import javax.resource.spi.XATerminator;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.geronimo.transaction.manager.ImportedTransactionActiveException;
import org.apache.geronimo.transaction.manager.TransactionImpl;
import org.apache.geronimo.transaction.manager.TransactionLog;
import org.apache.geronimo.transaction.manager.TransactionManagerImpl;
import org.apache.geronimo.transaction.manager.XAWork;
import org.apache.geronimo.transaction.manager.XidFactory;

public class GeronimoTransactionManager
extends TransactionManagerImpl
implements XATerminator,
XAWork {
    private final Map importedTransactions = new HashMap();
    private boolean isInRecovery = false;

    public GeronimoTransactionManager() throws XAException {
    }

    public GeronimoTransactionManager(int defaultTransactionTimeoutSeconds) throws XAException {
        super(defaultTransactionTimeoutSeconds);
    }

    public GeronimoTransactionManager(int defaultTransactionTimeoutSeconds, TransactionLog transactionLog) throws XAException {
        super(defaultTransactionTimeoutSeconds, transactionLog);
    }

    public GeronimoTransactionManager(int defaultTransactionTimeoutSeconds, XidFactory xidFactory, TransactionLog transactionLog) throws XAException {
        super(defaultTransactionTimeoutSeconds, xidFactory, transactionLog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Xid xid, boolean onePhase) throws XAException {
        Transaction importedTransaction;
        Map map = this.importedTransactions;
        synchronized (map) {
            importedTransaction = (Transaction)this.importedTransactions.remove(xid);
        }
        if (importedTransaction == null) {
            throw new XAException("No imported transaction for xid: " + xid);
        }
        try {
            int status = importedTransaction.getStatus();
            assert (status == 0 || status == 2) : "invalid status: " + status;
        }
        catch (SystemException e) {
            throw (XAException)new XAException().initCause(e);
        }
        this.commit(importedTransaction, onePhase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forget(Xid xid) throws XAException {
        Transaction importedTransaction;
        Map map = this.importedTransactions;
        synchronized (map) {
            importedTransaction = (Transaction)this.importedTransactions.remove(xid);
        }
        if (importedTransaction == null) {
            throw new XAException("No imported transaction for xid: " + xid);
        }
        this.forget(importedTransaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int prepare(Xid xid) throws XAException {
        Transaction importedTransaction;
        Map map = this.importedTransactions;
        synchronized (map) {
            importedTransaction = (Transaction)this.importedTransactions.get(xid);
        }
        if (importedTransaction == null) {
            throw new XAException("No imported transaction for xid: " + xid);
        }
        try {
            int status = importedTransaction.getStatus();
            assert (status == 0);
        }
        catch (SystemException e) {
            throw (XAException)new XAException().initCause(e);
        }
        return this.prepare(importedTransaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Xid[] recover(int flag) throws XAException {
        if (!this.isInRecovery) {
            if ((flag & 0x1000000) == 0) {
                throw new XAException(-6);
            }
            this.isInRecovery = true;
        }
        if ((flag & 0x800000) != 0) {
            this.isInRecovery = false;
        }
        if ((flag & 0x1000000) != 0) {
            Map<Xid, TransactionImpl> recoveredXidMap = this.getExternalXids();
            Xid[] recoveredXids = new Xid[recoveredXidMap.size()];
            int i = 0;
            Map map = this.importedTransactions;
            synchronized (map) {
                for (Map.Entry<Xid, TransactionImpl> entry : recoveredXidMap.entrySet()) {
                    Xid xid = entry.getKey();
                    recoveredXids[i++] = xid;
                    Transaction transaction = entry.getValue();
                    this.importedTransactions.put(xid, transaction);
                }
            }
            return recoveredXids;
        }
        return new Xid[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Xid xid) throws XAException {
        Transaction importedTransaction;
        Map map = this.importedTransactions;
        synchronized (map) {
            importedTransaction = (Transaction)this.importedTransactions.remove(xid);
        }
        if (importedTransaction == null) {
            throw new XAException("No imported transaction for xid: " + xid);
        }
        try {
            int status = importedTransaction.getStatus();
            assert (status == 0 || status == 2);
        }
        catch (SystemException e) {
            throw (XAException)new XAException().initCause(e);
        }
        this.rollback(importedTransaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void begin(Xid xid, long txTimeoutMillis) throws XAException, InvalidTransactionException, SystemException, ImportedTransactionActiveException {
        Map map = this.importedTransactions;
        synchronized (map) {
            Transaction importedTransaction = (Transaction)this.importedTransactions.get(xid);
            if (importedTransaction == null) {
                importedTransaction = this.importXid(xid, txTimeoutMillis);
                this.importedTransactions.put(xid, importedTransaction);
            }
            try {
                this.resume(importedTransaction);
            }
            catch (InvalidTransactionException e) {
                throw (ImportedTransactionActiveException)new ImportedTransactionActiveException(xid).initCause(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end(Xid xid) throws XAException, SystemException {
        Map map = this.importedTransactions;
        synchronized (map) {
            Transaction importedTransaction = (Transaction)this.importedTransactions.get(xid);
            if (importedTransaction == null) {
                throw new XAException("No imported transaction for xid: " + xid);
            }
            if (importedTransaction != this.getTransaction()) {
                throw new XAException("Imported transaction is not associated with the current thread xid: " + xid);
            }
            this.suspend();
        }
    }
}

