/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.heif;

import com.drew.imaging.heif.HeifHandler;
import com.drew.lang.SequentialByteArrayReader;
import com.drew.lang.SequentialReader;
import com.drew.metadata.Metadata;
import com.drew.metadata.heif.HeifDirectory;
import com.drew.metadata.heif.boxes.AuxiliaryTypeProperty;
import com.drew.metadata.heif.boxes.Box;
import com.drew.metadata.heif.boxes.ColourInformationBox;
import com.drew.metadata.heif.boxes.ImageRotationBox;
import com.drew.metadata.heif.boxes.ImageSpatialExtentsProperty;
import com.drew.metadata.heif.boxes.ItemInfoBox;
import com.drew.metadata.heif.boxes.ItemLocationBox;
import com.drew.metadata.heif.boxes.ItemProtectionBox;
import com.drew.metadata.heif.boxes.PixelInformationBox;
import com.drew.metadata.heif.boxes.PrimaryItemBox;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class HeifPictureHandler
extends HeifHandler<HeifDirectory> {
    ItemProtectionBox itemProtectionBox = null;
    PrimaryItemBox primaryItemBox = null;
    ItemInfoBox itemInfoBox = null;
    ItemLocationBox itemLocationBox = null;

    public HeifPictureHandler(Metadata metadata) {
        super(metadata);
    }

    @Override
    protected boolean shouldAcceptBox(Box box) {
        List<String> boxes = Arrays.asList("ipro", "pitm", "iinf", "iloc", "ispe", "auxC", "irot", "colr", "pixi");
        return boxes.contains(box.type);
    }

    @Override
    protected boolean shouldAcceptContainer(Box box) {
        return box.type.equals("iprp") || box.type.equals("ipco");
    }

    @Override
    protected HeifHandler processBox(Box box, byte[] payload) throws IOException {
        SequentialByteArrayReader reader = new SequentialByteArrayReader(payload);
        if (box.type.equals("ipro")) {
            this.itemProtectionBox = new ItemProtectionBox(reader, box);
        } else if (box.type.equals("pitm")) {
            this.primaryItemBox = new PrimaryItemBox(reader, box);
        } else if (box.type.equals("iinf")) {
            this.itemInfoBox = new ItemInfoBox(reader, box);
            this.itemInfoBox.addMetadata(this.directory);
        } else if (box.type.equals("iloc")) {
            this.itemLocationBox = new ItemLocationBox(reader, box);
        } else if (box.type.equals("ispe")) {
            ImageSpatialExtentsProperty imageSpatialExtentsProperty = new ImageSpatialExtentsProperty(reader, box);
            imageSpatialExtentsProperty.addMetadata(this.directory);
        } else if (box.type.equals("auxC")) {
            AuxiliaryTypeProperty auxiliaryTypeProperty = new AuxiliaryTypeProperty(reader, box);
        } else if (box.type.equals("irot")) {
            ImageRotationBox imageRotationBox = new ImageRotationBox(reader, box);
            imageRotationBox.addMetadata(this.directory);
        } else if (box.type.equals("colr")) {
            ColourInformationBox colourInformationBox = new ColourInformationBox(reader, box, this.metadata);
            colourInformationBox.addMetadata(this.directory);
        } else if (box.type.equals("pixi")) {
            PixelInformationBox pixelInformationBox = new PixelInformationBox(reader, box);
            pixelInformationBox.addMetadata(this.directory);
        }
        return this;
    }

    @Override
    protected void processContainer(Box box, SequentialReader reader) throws IOException {
    }

    @Override
    protected HeifDirectory getDirectory() {
        return new HeifDirectory();
    }
}

