/*
 * Decompiled with CFR 0.152.
 */
package com.day.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;

public class OrderedStringKeyMap {
    private final ArrayList list = new ArrayList();
    private final HashMap map = new HashMap();

    public int size() {
        return this.list.size();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public boolean contains(Object o) {
        return this.map.containsValue(o);
    }

    public boolean contains(String key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(Object o) {
        return this.map.containsValue(o);
    }

    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    public Object get(String key) {
        return this.map.get(key);
    }

    public Object get(int index) {
        return this.list.get(index);
    }

    public Iterator iterator() {
        return this.list.iterator();
    }

    public Iterator iterator(boolean reverse) {
        return reverse ? new ReverseListIterator(this.list) : this.list.iterator();
    }

    public Iterator keys() {
        return this.map.keySet().iterator();
    }

    public Object[] toArray() {
        return this.list.toArray();
    }

    public Object[] toArray(Object[] a) {
        return this.list.toArray(a);
    }

    public void clear() {
        this.list.clear();
        this.map.clear();
    }

    public Object put(String key, Object value) {
        Object old = this.map.put(key, value);
        if (old != null) {
            this.list.remove(old);
        }
        this.list.add(value);
        return old;
    }

    public Object set(String key, Object value) {
        Object old = this.map.put(key, value);
        if (old != null) {
            int idx = this.list.indexOf(old);
            this.list.remove(old);
            this.list.add(idx, value);
        } else {
            this.list.add(value);
        }
        return old;
    }

    public int indexOf(Object value) {
        return this.list.indexOf(value);
    }

    public Object put(String key, Object value, int index) {
        Object old = this.map.remove(key);
        if (old != null) {
            this.list.remove(old);
        }
        this.list.add(index, value);
        this.map.put(key, value);
        return old;
    }

    public Object put(String key, Object value, String above) {
        Object old = this.map.remove(key);
        if (old != null) {
            this.list.remove(old);
        }
        int index = above == null ? -1 : this.list.indexOf(this.map.get(above));
        this.map.put(key, value);
        if (index < 0) {
            this.list.add(value);
        } else {
            this.list.add(index, value);
        }
        return old;
    }

    public Object remove(String key) {
        Object old = this.map.remove(key);
        if (old != null) {
            this.list.remove(old);
        }
        return old;
    }

    public Object remove(int index) {
        Object old = this.list.remove(index);
        if (old != null) {
            this.map.remove(old);
        }
        return old;
    }

    public Object lastElement() {
        if (this.list.isEmpty()) {
            return null;
        }
        return this.list.get(this.list.size() - 1);
    }

    public void move(String key, String above) {
        Object aboveElem;
        Object elem = this.map.get(key);
        if (elem == null) {
            throw new NoSuchElementException(key);
        }
        if (key.equals(above)) {
            return;
        }
        if (above == null || above.equals("") || (aboveElem = this.map.get(above)) == null) {
            this.list.remove(elem);
            this.list.add(elem);
        } else {
            this.list.remove(elem);
            this.list.add(this.list.indexOf(aboveElem), elem);
        }
    }

    public Set entrySet() {
        return this.map.entrySet();
    }

    public Set keySet() {
        return this.map.keySet();
    }

    private static final class ReverseListIterator
    implements Iterator {
        private final List list;
        private int pos;

        public ReverseListIterator(List list) {
            this.list = list;
            this.pos = list.size() - 1;
        }

        public boolean hasNext() {
            return this.pos >= 0;
        }

        public Object next() throws NoSuchElementException {
            if (this.pos < 0) {
                throw new NoSuchElementException();
            }
            return this.list.get(this.pos--);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

