/*
 * Decompiled with CFR 0.152.
 */
package com.day.image;

import com.day.image.Layer;
import com.day.image.font.AbstractFont;
import com.day.image.font.FontListEntry;
import com.day.image.internal.font.FontHelper;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.text.CharacterIterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Font
extends AbstractFont {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final AbstractFont delegatee;

    public static List<FontListEntry> getFontList() {
        return FontHelper.getInstance().getFontList();
    }

    public Font(String faceName, int size, int style) {
        this.log.debug("Font: Looking for {}/{}/{}", faceName, size, Font.styleToDescription(style));
        this.delegatee = FontHelper.getInstance().getFont(faceName, size, style);
        this.log.debug("Font: Using font {}", (Object)this.delegatee);
    }

    public Font(String faceName, int size) {
        this(faceName, size, 0);
    }

    @Override
    public Rectangle2D getTextExtent(int x, int y, int width, int height, String text, int align, double cs, int ls) {
        return this.delegatee.getTextExtent(x, y, width, height, text, align, cs, ls);
    }

    @Override
    public int drawText(Layer layer, int x, int y, int width, int height, String text, Paint paint, Stroke stroke, int align, double cs, int ls) {
        return this.delegatee.drawText(layer, x, y, width, height, text, paint, stroke, align, cs, ls);
    }

    @Override
    public double getHeight() {
        return this.delegatee.getHeight();
    }

    @Override
    public double getAscent() {
        return this.delegatee.getAscent();
    }

    @Override
    public double getDescent() {
        return this.delegatee.getDescent();
    }

    @Override
    public boolean canDisplay(char c) {
        return this.delegatee.canDisplay(c);
    }

    @Override
    public int canDisplayUpTo(CharacterIterator iter, int start, int limit) {
        return this.delegatee.canDisplayUpTo(iter, start, limit);
    }

    @Override
    public int canDisplayUpTo(String str) {
        return this.delegatee.canDisplayUpTo(str);
    }

    @Override
    public int canDisplayUpTo(char[] text, int start, int limit) {
        return this.delegatee.canDisplayUpTo(text, start, limit);
    }

    @Override
    public String toString() {
        return this.delegatee.toString();
    }

    @Override
    public java.awt.Font getAwtFont() {
        return this.delegatee.getAwtFont();
    }
}

