/*
 * Decompiled with CFR 0.152.
 */
package com.day.image;

import java.awt.Color;

public class ColorCurve {
    public static final int MAX_LEVEL = 256;
    private static final float[] IDENTITY_CURVE = new float[256];
    private final Color color;
    private final float[] curve;

    public ColorCurve(ColorCurve colorCurve) {
        this.color = colorCurve.color;
        this.curve = colorCurve.curve == null ? null : (float[])colorCurve.curve.clone();
    }

    public ColorCurve(Color color) {
        this.color = color;
        this.curve = IDENTITY_CURVE;
    }

    public ColorCurve(Color color, float[] curve) {
        this.color = color;
        this.curve = curve == null || curve.length < 2 ? IDENTITY_CURVE : this.evenlySpacedCurve(curve);
    }

    public ColorCurve(Color color, float[] curve, float[] intervals) {
        this.color = color;
        this.curve = curve == null || curve.length < 2 ? IDENTITY_CURVE : this.intervalCurve(curve, intervals);
    }

    public Color getColor() {
        return this.color;
    }

    public float getLevel(int step) {
        return this.curve[step];
    }

    private float[] evenlySpacedCurve(float[] curve) {
        float[] intervals = new float[curve.length - 1];
        for (int i = 0; i < intervals.length; ++i) {
            intervals[i] = 1.0f;
        }
        return this.intervalCurve(curve, intervals);
    }

    private float[] intervalCurve(float[] curve, float[] intervals) {
        if (intervals == null || intervals.length != curve.length - 1) {
            return this.evenlySpacedCurve(curve);
        }
        float factor = 0.0f;
        for (int i = 0; i < intervals.length; ++i) {
            factor += intervals[i];
        }
        float[] res = new float[256];
        int resI = 0;
        float level1 = curve[0];
        for (int i = 1; i < curve.length; ++i) {
            float level0 = level1;
            float interval = intervals[i - 1] * 256.0f / factor;
            int end = (int)((float)resI + interval + 0.5f);
            if (end > 256 || i == curve.length - 1) {
                end = 256;
            }
            level1 = curve[i];
            float step = (level1 - level0) / (float)(end - resI);
            while (resI < end) {
                res[resI] = level0;
                level0 += step;
                ++resI;
            }
        }
        return res;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            ColorCurve.IDENTITY_CURVE[i] = (float)i / 256.0f;
        }
    }
}

