/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.statistics.query;

import com.day.crx.statistics.Report;
import com.day.crx.statistics.query.Query;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.QueryManager;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.util.Text;

public class QueryHistoryReport
extends Report {
    private final String query;
    private int period = 12;

    public QueryHistoryReport(String dataPath, String query) {
        super(dataPath);
        this.query = query;
    }

    public Iterator getResult(Session session) throws RepositoryException {
        String path;
        Query dummy = new Query(this.getDataPath(), "dummy", 0L, 0L);
        TreeMap<String, Long> buckets = new TreeMap<String, Long>();
        Calendar cal = Calendar.getInstance();
        cal.add(2, -(this.getPeriod() - 1));
        cal.set(5, 1);
        for (int i = 0; i < this.getPeriod(); ++i) {
            buckets.put(Text.getRelativeParent(dummy.getPath(), 2), new Long(0L));
            dummy.setTimestamp(cal.getTimeInMillis());
            cal.add(2, 1);
        }
        QueryManager qm = session.getWorkspace().getQueryManager();
        StringBuffer stmt = new StringBuffer("/jcr:root");
        stmt.append(this.getDataPath());
        stmt.append("/*/*/*/");
        stmt.append(ISO9075.encode(this.query));
        NodeIterator nodes = qm.createQuery(stmt.toString(), "xpath").execute().getNodes();
        while (nodes.hasNext()) {
            Node n = nodes.nextNode();
            long count = n.getProperty("count").getLong();
            path = n.getAncestor(n.getDepth() - 2).getPath();
            Long c = (Long)buckets.get(path);
            if (c == null) continue;
            buckets.put(path, new Long(c + count));
        }
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        for (Map.Entry entry : buckets.entrySet()) {
            path = (String)entry.getKey();
            Long count = (Long)entry.getValue();
            data.add(new Object[]{path, count});
        }
        return data.iterator();
    }

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }
}

