/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.workflow.compatibility;

import com.adobe.granite.workflow.exec.DynamicParticipantExecutor;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import com.day.cq.workflow.WorkflowService;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.ParticipantChooser;
import com.day.cq.workflow.exec.ParticipantStepChooser;
import com.day.cq.workflow.impl.CQWorkflowSessionWrapper;
import com.day.cq.workflow.impl.exec.CQWorkItemWrapper;
import com.day.cq.workflow.impl.metadata.CQMetaDataMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.References;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false, label="%cq.workflow.compat.executor.dynamicparticipant.name", description="%cq.workflow.compat.executor.dynamicparticipant.description")
@Property(name="service.description", value={"%cq.workflow.compat.executor.dynamicparticipant.description"})
@References(value={@Reference(name="ParticipantChooser", cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, referenceInterface=ParticipantChooser.class, policy=ReferencePolicy.DYNAMIC), @Reference(name="ParticipantStepChooser", cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, referenceInterface=ParticipantStepChooser.class, policy=ReferencePolicy.DYNAMIC)})
@Service
public class CQDynamicParticipantExecutor
implements DynamicParticipantExecutor {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference
    private WorkflowService cqWorkflowService;
    protected List<ParticipantChooser> participantChooser = new CopyOnWriteArrayList<ParticipantChooser>();
    protected List<ParticipantStepChooser> participantStepChooser = new CopyOnWriteArrayList<ParticipantStepChooser>();

    public void bindParticipantChooser(ParticipantChooser aParticipantChooser) {
        this.participantChooser.add(aParticipantChooser);
    }

    public void unbindParticipantChooser(ParticipantChooser aParticipantChooser) {
        this.participantChooser.remove(aParticipantChooser);
    }

    public void bindParticipantStepChooser(ParticipantStepChooser aParticipantStepChooser) {
        this.participantStepChooser.add(aParticipantStepChooser);
    }

    public void unbindParticipantStepChooser(ParticipantStepChooser aParticipantStepChooser) {
        this.participantStepChooser.remove(aParticipantStepChooser);
    }

    @Override
    public boolean canExecute(String aResourceName) {
        return this.evaluateExecutable(aResourceName) != null;
    }

    @Override
    public String getParticipant(String aResourceName, WorkItem workItem, com.adobe.granite.workflow.WorkflowSession workflowSession, MetaDataMap metaDataMap) {
        Object toBeExecuted = this.evaluateExecutable(aResourceName);
        try {
            if (toBeExecuted != null) {
                CQWorkflowSessionWrapper sessionWrapper = new CQWorkflowSessionWrapper(this.cqWorkflowService, workflowSession);
                CQWorkItemWrapper workItemWrapper = new CQWorkItemWrapper(workItem);
                CQMetaDataMap cqMetaDataMap = new CQMetaDataMap(metaDataMap);
                String[] args = this.getArgs(workItem);
                if (toBeExecuted instanceof ParticipantStepChooser) {
                    ParticipantStepChooser chooser = (ParticipantStepChooser)toBeExecuted;
                    return chooser.getParticipant((com.day.cq.workflow.exec.WorkItem)workItemWrapper, (WorkflowSession)sessionWrapper, (com.day.cq.workflow.metadata.MetaDataMap)cqMetaDataMap);
                }
                if (toBeExecuted instanceof ParticipantChooser) {
                    ParticipantChooser chooser = (ParticipantChooser)toBeExecuted;
                    return chooser.getParticipant((com.day.cq.workflow.exec.WorkItem)workItemWrapper, (WorkflowSession)sessionWrapper, args);
                }
            }
        }
        catch (Exception e) {
            this.log.error("ParticipantChooser execution resulted in an error: " + e.getMessage(), e);
        }
        return null;
    }

    private Object evaluateExecutable(String resource) {
        Object toBeExecuted = null;
        for (ParticipantStepChooser participantStepChooser : this.participantStepChooser) {
            if (!resource.equals(participantStepChooser.getClass().getName())) continue;
            toBeExecuted = participantStepChooser;
            break;
        }
        if (toBeExecuted == null) {
            for (ParticipantChooser participantChooser : this.participantChooser) {
                if (!resource.equals(participantChooser.getClass().getName())) continue;
                toBeExecuted = participantChooser;
                break;
            }
        }
        return toBeExecuted;
    }

    protected String[] getArgs(WorkItem item) {
        String arguments = (String)((Object)item.getNode().getMetaDataMap().get("PROCESS_ARGS", String.class));
        if (arguments != null && !arguments.equals("")) {
            return arguments.split(",");
        }
        return new String[0];
    }

    protected void bindCqWorkflowService(WorkflowService workflowService) {
        this.cqWorkflowService = workflowService;
    }

    protected void unbindCqWorkflowService(WorkflowService workflowService) {
        if (this.cqWorkflowService == workflowService) {
            this.cqWorkflowService = null;
        }
    }
}

