/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.msm.commons;

import com.day.cq.wcm.api.WCMException;
import com.day.cq.wcm.msm.api.LiveRelationship;
import com.day.cq.wcm.msm.commons.BaseAction;
import com.day.cq.wcm.msm.commons.BaseActionFactory;
import com.day.cq.wcm.msm.commons.ItemFilterImpl;
import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.commons.collections.FunctorException;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.Predicate;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FilteredAction
extends BaseAction {
    private final ItemFilterImpl componentItemFilter;
    private final ItemFilterImpl pagePropertyFilter;

    protected FilteredAction(ValueMap configuration, ItemFilterImpl pageItemFilter, ItemFilterImpl componentItemFilter, BaseActionFactory<? extends FilteredAction> factory) {
        super(configuration, factory);
        this.pagePropertyFilter = pageItemFilter;
        this.componentItemFilter = componentItemFilter;
    }

    @Override
    protected boolean handles(Resource source, Resource target, LiveRelationship relation, boolean resetRollout) throws RepositoryException, WCMException {
        return this.filter(source, target) && this.doHandle(source, target, relation, resetRollout);
    }

    protected abstract boolean doHandle(Resource var1, Resource var2, LiveRelationship var3, boolean var4) throws RepositoryException, WCMException;

    protected ItemFilterImpl getFilter(Node node) throws RepositoryException {
        if (FilteredAction.isPage(node)) {
            return this.pagePropertyFilter;
        }
        return this.componentItemFilter;
    }

    protected Iterator<Property> getFilteredProperties(Node node) throws RepositoryException {
        return IteratorUtils.filteredIterator(node.getProperties(), new ItemFilterPredicate(this.getFilter(node)));
    }

    protected Iterator<Node> getFilteredNodes(Node node) throws RepositoryException {
        return IteratorUtils.filteredIterator(node.getNodes(), new ItemFilterPredicate(this.getFilter(node)));
    }

    private boolean filter(Resource source, Resource target) throws RepositoryException {
        Node sourceNode = source != null ? source.adaptTo(Node.class) : null;
        Node targetNode = target != null ? target.adaptTo(Node.class) : null;
        Node checkNode = sourceNode != null ? sourceNode : targetNode;
        return checkNode == null || !this.getFilter(checkNode).excludes(checkNode);
    }

    protected static final class ItemFilterPredicate
    implements Predicate {
        private final ItemFilterImpl filter;

        protected ItemFilterPredicate(ItemFilterImpl filter) {
            this.filter = filter;
        }

        public boolean evaluate(Object object) {
            try {
                if (object instanceof Property) {
                    return !this.filter.excludes((Property)object);
                }
                return !this.filter.excludes((Node)object);
            }
            catch (RepositoryException e) {
                throw new FunctorException(e);
            }
        }
    }
}

